<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for consultarDados StructType
 * @subpackage Structs
 */
class ConsultarDados extends AbstractStructBase
{
    /**
     * The cnpj
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $cnpj;
    /**
     * The idSessao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idSessao;
    /**
     * Constructor method for consultarDados
     * @uses ConsultarDados::setCnpj()
     * @uses ConsultarDados::setIdSessao()
     * @param int $cnpj
     * @param string $idSessao
     */
    public function __construct($cnpj = null, $idSessao = null)
    {
        $this
            ->setCnpj($cnpj)
            ->setIdSessao($idSessao);
    }
    /**
     * Get cnpj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCnpj()
    {
        return isset($this->cnpj) ? $this->cnpj : null;
    }
    /**
     * Set cnpj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cnpj
     * @return \StructType\ConsultarDados
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: int
        if (!is_null($cnpj) && !is_numeric($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cnpj)), __LINE__);
        }
        if (is_null($cnpj) || (is_array($cnpj) && empty($cnpj))) {
            unset($this->cnpj);
        } else {
            $this->cnpj = $cnpj;
        }
        return $this;
    }
    /**
     * Get idSessao value
     * @return string|null
     */
    public function getIdSessao()
    {
        return $this->idSessao;
    }
    /**
     * Set idSessao value
     * @param string $idSessao
     * @return \StructType\ConsultarDados
     */
    public function setIdSessao($idSessao = null)
    {
        // validation for constraint: string
        if (!is_null($idSessao) && !is_string($idSessao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idSessao)), __LINE__);
        }
        $this->idSessao = $idSessao;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsultarDados
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
