<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoParcelamento StructType
 * @subpackage Structs
 */
class DocumentoParcelamento extends AbstractStructBase
{
    /**
     * The CnpjCpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CnpjCpf;
    /**
     * The DataPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The NumParcela
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NumParcela;
    /**
     * The NumRqp
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NumRqp;
    /**
     * Constructor method for DocumentoParcelamento
     * @uses DocumentoParcelamento::setCnpjCpf()
     * @uses DocumentoParcelamento::setDataPagamento()
     * @uses DocumentoParcelamento::setNumParcela()
     * @uses DocumentoParcelamento::setNumRqp()
     * @param string $cnpjCpf
     * @param string $dataPagamento
     * @param string $numParcela
     * @param string $numRqp
     */
    public function __construct($cnpjCpf = null, $dataPagamento = null, $numParcela = null, $numRqp = null)
    {
        $this
            ->setCnpjCpf($cnpjCpf)
            ->setDataPagamento($dataPagamento)
            ->setNumParcela($numParcela)
            ->setNumRqp($numRqp);
    }
    /**
     * Get CnpjCpf value
     * @return string
     */
    public function getCnpjCpf()
    {
        return $this->CnpjCpf;
    }
    /**
     * Set CnpjCpf value
     * @param string $cnpjCpf
     * @return \StructType\DocumentoParcelamento
     */
    public function setCnpjCpf($cnpjCpf = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjCpf) && !is_string($cnpjCpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cnpjCpf)), __LINE__);
        }
        $this->CnpjCpf = $cnpjCpf;
        return $this;
    }
    /**
     * Get DataPagamento value
     * @return string
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\DocumentoParcelamento
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get NumParcela value
     * @return string
     */
    public function getNumParcela()
    {
        return $this->NumParcela;
    }
    /**
     * Set NumParcela value
     * @param string $numParcela
     * @return \StructType\DocumentoParcelamento
     */
    public function setNumParcela($numParcela = null)
    {
        // validation for constraint: string
        if (!is_null($numParcela) && !is_string($numParcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numParcela)), __LINE__);
        }
        $this->NumParcela = $numParcela;
        return $this;
    }
    /**
     * Get NumRqp value
     * @return string
     */
    public function getNumRqp()
    {
        return $this->NumRqp;
    }
    /**
     * Set NumRqp value
     * @param string $numRqp
     * @return \StructType\DocumentoParcelamento
     */
    public function setNumRqp($numRqp = null)
    {
        // validation for constraint: string
        if (!is_null($numRqp) && !is_string($numRqp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numRqp)), __LINE__);
        }
        $this->NumRqp = $numRqp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentoParcelamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
