<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Documento StructType
 * @subpackage Structs
 */
class Documento extends AbstractStructBase
{
    /**
     * The DataPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The SqDocumento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SqDocumento;
    /**
     * The TipoDocumento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TipoDocumento;
    /**
     * The TipoPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TipoPagamento;
    /**
     * The ItensPagamentos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemPagamento
     */
    public $ItensPagamentos;
    /**
     * Constructor method for Documento
     * @uses Documento::setDataPagamento()
     * @uses Documento::setSqDocumento()
     * @uses Documento::setTipoDocumento()
     * @uses Documento::setTipoPagamento()
     * @uses Documento::setItensPagamentos()
     * @param string $dataPagamento
     * @param int $sqDocumento
     * @param int $tipoDocumento
     * @param int $tipoPagamento
     * @param \ArrayType\ArrayOfItemPagamento $itensPagamentos
     */
    public function __construct($dataPagamento = null, $sqDocumento = null, $tipoDocumento = null, $tipoPagamento = null, \ArrayType\ArrayOfItemPagamento $itensPagamentos = null)
    {
        $this
            ->setDataPagamento($dataPagamento)
            ->setSqDocumento($sqDocumento)
            ->setTipoDocumento($tipoDocumento)
            ->setTipoPagamento($tipoPagamento)
            ->setItensPagamentos($itensPagamentos);
    }
    /**
     * Get DataPagamento value
     * @return string
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\Documento
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get SqDocumento value
     * @return int
     */
    public function getSqDocumento()
    {
        return $this->SqDocumento;
    }
    /**
     * Set SqDocumento value
     * @param int $sqDocumento
     * @return \StructType\Documento
     */
    public function setSqDocumento($sqDocumento = null)
    {
        // validation for constraint: int
        if (!is_null($sqDocumento) && !is_numeric($sqDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sqDocumento)), __LINE__);
        }
        $this->SqDocumento = $sqDocumento;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return int
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @param int $tipoDocumento
     * @return \StructType\Documento
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: int
        if (!is_null($tipoDocumento) && !is_numeric($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipoDocumento)), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get TipoPagamento value
     * @return int
     */
    public function getTipoPagamento()
    {
        return $this->TipoPagamento;
    }
    /**
     * Set TipoPagamento value
     * @param int $tipoPagamento
     * @return \StructType\Documento
     */
    public function setTipoPagamento($tipoPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($tipoPagamento) && !is_numeric($tipoPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipoPagamento)), __LINE__);
        }
        $this->TipoPagamento = $tipoPagamento;
        return $this;
    }
    /**
     * Get ItensPagamentos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemPagamento|null
     */
    public function getItensPagamentos()
    {
        return isset($this->ItensPagamentos) ? $this->ItensPagamentos : null;
    }
    /**
     * Set ItensPagamentos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemPagamento $itensPagamentos
     * @return \StructType\Documento
     */
    public function setItensPagamentos(\ArrayType\ArrayOfItemPagamento $itensPagamentos = null)
    {
        if (is_null($itensPagamentos) || (is_array($itensPagamentos) && empty($itensPagamentos))) {
            unset($this->ItensPagamentos);
        } else {
            $this->ItensPagamentos = $itensPagamentos;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Documento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
