<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviar ServiceType
 * @subpackage Services
 */
class Enviar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named enviarDadosAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDadosAuto $parameters
     * @return \StructType\EnviarDadosAutoResponse|bool
     */
    public function enviarDadosAuto(\StructType\EnviarDadosAuto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDadosAuto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarDados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDados $parameters
     * @return \StructType\EnviarDadosResponse|bool
     */
    public function enviarDados(\StructType\EnviarDados $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarDadosCDI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDadosCDI $parameters
     * @return \StructType\EnviarDadosCDIResponse|bool
     */
    public function enviarDadosCDI(\StructType\EnviarDadosCDI $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDadosCDI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarDadosProcEspecial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDadosProcEspecial $parameters
     * @return \StructType\EnviarDadosProcEspecialResponse|bool
     */
    public function enviarDadosProcEspecial(\StructType\EnviarDadosProcEspecial $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDadosProcEspecial($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarDadosParcelamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDadosParcelamento $parameters
     * @return \StructType\EnviarDadosParcelamentoResponse|bool
     */
    public function enviarDadosParcelamento(\StructType\EnviarDadosParcelamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDadosParcelamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarDadosITD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDadosITD $parameters
     * @return \StructType\EnviarDadosITDResponse|bool
     */
    public function enviarDadosITD(\StructType\EnviarDadosITD $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDadosITD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enviarDadosPrecatorio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarDadosPrecatorio $parameters
     * @return \StructType\EnviarDadosPrecatorioResponse|bool
     */
    public function enviarDadosPrecatorio(\StructType\EnviarDadosPrecatorio $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enviarDadosPrecatorio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviarDadosAutoResponse|\StructType\EnviarDadosCDIResponse|\StructType\EnviarDadosITDResponse|\StructType\EnviarDadosParcelamentoResponse|\StructType\EnviarDadosPrecatorioResponse|\StructType\EnviarDadosProcEspecialResponse|\StructType\EnviarDadosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
