<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPagamento StructType
 * @subpackage Structs
 */
class ItemPagamento extends AbstractStructBase
{
    /**
     * The CepContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $CepContribuinte;
    /**
     * The Cnpj
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Cnpj;
    /**
     * The CodigoProduto
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CodigoProduto;
    /**
     * The Cpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Cpf;
    /**
     * The DataFatoGerador
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataFatoGerador;
    /**
     * The DataVencimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataVencimento;
    /**
     * The DddContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $DddContribuinte;
    /**
     * The DiaVencimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $DiaVencimento;
    /**
     * The EnderecoContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EnderecoContribuinte;
    /**
     * The InformacoesComplementares
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InformacoesComplementares;
    /**
     * The InscEstadualRJ
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $InscEstadualRJ;
    /**
     * The MunicipioContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MunicipioContribuinte;
    /**
     * The Natureza
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Natureza;
    /**
     * The NaturezaQualificacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NaturezaQualificacao;
    /**
     * The NomeRazaoSocial
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NomeRazaoSocial;
    /**
     * The NotaFiscalCnpj
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NotaFiscalCnpj;
    /**
     * The NotaFiscalCpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NotaFiscalCpf;
    /**
     * The NotaFiscalDataEmissao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NotaFiscalDataEmissao;
    /**
     * The NotaFiscalNumero
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NotaFiscalNumero;
    /**
     * The NotaFiscalSerie
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $NotaFiscalSerie;
    /**
     * The NotaFiscalTipo
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NotaFiscalTipo;
    /**
     * The NumControleContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NumControleContribuinte;
    /**
     * The NumDocOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumDocOrigem;
    /**
     * The Passaporte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Passaporte;
    /**
     * The PeriodoReferenciaAno
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $PeriodoReferenciaAno;
    /**
     * The PeriodoReferenciaDecendio
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $PeriodoReferenciaDecendio;
    /**
     * The PeriodoReferenciaMes
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $PeriodoReferenciaMes;
    /**
     * The TelefoneContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TelefoneContribuinte;
    /**
     * The TipoApuracao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $TipoApuracao;
    /**
     * The TipoId
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $TipoId;
    /**
     * The TipoImportacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $TipoImportacao;
    /**
     * The TipoPeriodoApuracao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TipoPeriodoApuracao;
    /**
     * The UfContribuinte
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UfContribuinte;
    /**
     * The ValorFECPPrincipal
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorFECPPrincipal;
    /**
     * The ValorICMSPrincipal
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorICMSPrincipal;
    /**
     * The ValorTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorTotal;
    /**
     * Constructor method for ItemPagamento
     * @uses ItemPagamento::setCepContribuinte()
     * @uses ItemPagamento::setCnpj()
     * @uses ItemPagamento::setCodigoProduto()
     * @uses ItemPagamento::setCpf()
     * @uses ItemPagamento::setDataFatoGerador()
     * @uses ItemPagamento::setDataVencimento()
     * @uses ItemPagamento::setDddContribuinte()
     * @uses ItemPagamento::setDiaVencimento()
     * @uses ItemPagamento::setEnderecoContribuinte()
     * @uses ItemPagamento::setInformacoesComplementares()
     * @uses ItemPagamento::setInscEstadualRJ()
     * @uses ItemPagamento::setMunicipioContribuinte()
     * @uses ItemPagamento::setNatureza()
     * @uses ItemPagamento::setNaturezaQualificacao()
     * @uses ItemPagamento::setNomeRazaoSocial()
     * @uses ItemPagamento::setNotaFiscalCnpj()
     * @uses ItemPagamento::setNotaFiscalCpf()
     * @uses ItemPagamento::setNotaFiscalDataEmissao()
     * @uses ItemPagamento::setNotaFiscalNumero()
     * @uses ItemPagamento::setNotaFiscalSerie()
     * @uses ItemPagamento::setNotaFiscalTipo()
     * @uses ItemPagamento::setNumControleContribuinte()
     * @uses ItemPagamento::setNumDocOrigem()
     * @uses ItemPagamento::setPassaporte()
     * @uses ItemPagamento::setPeriodoReferenciaAno()
     * @uses ItemPagamento::setPeriodoReferenciaDecendio()
     * @uses ItemPagamento::setPeriodoReferenciaMes()
     * @uses ItemPagamento::setTelefoneContribuinte()
     * @uses ItemPagamento::setTipoApuracao()
     * @uses ItemPagamento::setTipoId()
     * @uses ItemPagamento::setTipoImportacao()
     * @uses ItemPagamento::setTipoPeriodoApuracao()
     * @uses ItemPagamento::setUfContribuinte()
     * @uses ItemPagamento::setValorFECPPrincipal()
     * @uses ItemPagamento::setValorICMSPrincipal()
     * @uses ItemPagamento::setValorTotal()
     * @param int $cepContribuinte
     * @param int $cnpj
     * @param int $codigoProduto
     * @param int $cpf
     * @param string $dataFatoGerador
     * @param string $dataVencimento
     * @param int $dddContribuinte
     * @param int $diaVencimento
     * @param string $enderecoContribuinte
     * @param string $informacoesComplementares
     * @param int $inscEstadualRJ
     * @param string $municipioContribuinte
     * @param int $natureza
     * @param int $naturezaQualificacao
     * @param string $nomeRazaoSocial
     * @param int $notaFiscalCnpj
     * @param int $notaFiscalCpf
     * @param string $notaFiscalDataEmissao
     * @param int $notaFiscalNumero
     * @param int $notaFiscalSerie
     * @param string $notaFiscalTipo
     * @param string $numControleContribuinte
     * @param int $numDocOrigem
     * @param string $passaporte
     * @param int $periodoReferenciaAno
     * @param int $periodoReferenciaDecendio
     * @param int $periodoReferenciaMes
     * @param int $telefoneContribuinte
     * @param int $tipoApuracao
     * @param int $tipoId
     * @param int $tipoImportacao
     * @param string $tipoPeriodoApuracao
     * @param string $ufContribuinte
     * @param float $valorFECPPrincipal
     * @param float $valorICMSPrincipal
     * @param float $valorTotal
     */
    public function __construct($cepContribuinte = null, $cnpj = null, $codigoProduto = null, $cpf = null, $dataFatoGerador = null, $dataVencimento = null, $dddContribuinte = null, $diaVencimento = null, $enderecoContribuinte = null, $informacoesComplementares = null, $inscEstadualRJ = null, $municipioContribuinte = null, $natureza = null, $naturezaQualificacao = null, $nomeRazaoSocial = null, $notaFiscalCnpj = null, $notaFiscalCpf = null, $notaFiscalDataEmissao = null, $notaFiscalNumero = null, $notaFiscalSerie = null, $notaFiscalTipo = null, $numControleContribuinte = null, $numDocOrigem = null, $passaporte = null, $periodoReferenciaAno = null, $periodoReferenciaDecendio = null, $periodoReferenciaMes = null, $telefoneContribuinte = null, $tipoApuracao = null, $tipoId = null, $tipoImportacao = null, $tipoPeriodoApuracao = null, $ufContribuinte = null, $valorFECPPrincipal = null, $valorICMSPrincipal = null, $valorTotal = null)
    {
        $this
            ->setCepContribuinte($cepContribuinte)
            ->setCnpj($cnpj)
            ->setCodigoProduto($codigoProduto)
            ->setCpf($cpf)
            ->setDataFatoGerador($dataFatoGerador)
            ->setDataVencimento($dataVencimento)
            ->setDddContribuinte($dddContribuinte)
            ->setDiaVencimento($diaVencimento)
            ->setEnderecoContribuinte($enderecoContribuinte)
            ->setInformacoesComplementares($informacoesComplementares)
            ->setInscEstadualRJ($inscEstadualRJ)
            ->setMunicipioContribuinte($municipioContribuinte)
            ->setNatureza($natureza)
            ->setNaturezaQualificacao($naturezaQualificacao)
            ->setNomeRazaoSocial($nomeRazaoSocial)
            ->setNotaFiscalCnpj($notaFiscalCnpj)
            ->setNotaFiscalCpf($notaFiscalCpf)
            ->setNotaFiscalDataEmissao($notaFiscalDataEmissao)
            ->setNotaFiscalNumero($notaFiscalNumero)
            ->setNotaFiscalSerie($notaFiscalSerie)
            ->setNotaFiscalTipo($notaFiscalTipo)
            ->setNumControleContribuinte($numControleContribuinte)
            ->setNumDocOrigem($numDocOrigem)
            ->setPassaporte($passaporte)
            ->setPeriodoReferenciaAno($periodoReferenciaAno)
            ->setPeriodoReferenciaDecendio($periodoReferenciaDecendio)
            ->setPeriodoReferenciaMes($periodoReferenciaMes)
            ->setTelefoneContribuinte($telefoneContribuinte)
            ->setTipoApuracao($tipoApuracao)
            ->setTipoId($tipoId)
            ->setTipoImportacao($tipoImportacao)
            ->setTipoPeriodoApuracao($tipoPeriodoApuracao)
            ->setUfContribuinte($ufContribuinte)
            ->setValorFECPPrincipal($valorFECPPrincipal)
            ->setValorICMSPrincipal($valorICMSPrincipal)
            ->setValorTotal($valorTotal);
    }
    /**
     * Get CepContribuinte value
     * @return int
     */
    public function getCepContribuinte()
    {
        return $this->CepContribuinte;
    }
    /**
     * Set CepContribuinte value
     * @param int $cepContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setCepContribuinte($cepContribuinte = null)
    {
        // validation for constraint: int
        if (!is_null($cepContribuinte) && !is_numeric($cepContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cepContribuinte)), __LINE__);
        }
        $this->CepContribuinte = $cepContribuinte;
        return $this;
    }
    /**
     * Get Cnpj value
     * @return int
     */
    public function getCnpj()
    {
        return $this->Cnpj;
    }
    /**
     * Set Cnpj value
     * @param int $cnpj
     * @return \StructType\ItemPagamento
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: int
        if (!is_null($cnpj) && !is_numeric($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cnpj)), __LINE__);
        }
        $this->Cnpj = $cnpj;
        return $this;
    }
    /**
     * Get CodigoProduto value
     * @return int
     */
    public function getCodigoProduto()
    {
        return $this->CodigoProduto;
    }
    /**
     * Set CodigoProduto value
     * @param int $codigoProduto
     * @return \StructType\ItemPagamento
     */
    public function setCodigoProduto($codigoProduto = null)
    {
        // validation for constraint: int
        if (!is_null($codigoProduto) && !is_numeric($codigoProduto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoProduto)), __LINE__);
        }
        $this->CodigoProduto = $codigoProduto;
        return $this;
    }
    /**
     * Get Cpf value
     * @return int
     */
    public function getCpf()
    {
        return $this->Cpf;
    }
    /**
     * Set Cpf value
     * @param int $cpf
     * @return \StructType\ItemPagamento
     */
    public function setCpf($cpf = null)
    {
        // validation for constraint: int
        if (!is_null($cpf) && !is_numeric($cpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cpf)), __LINE__);
        }
        $this->Cpf = $cpf;
        return $this;
    }
    /**
     * Get DataFatoGerador value
     * @return string
     */
    public function getDataFatoGerador()
    {
        return $this->DataFatoGerador;
    }
    /**
     * Set DataFatoGerador value
     * @param string $dataFatoGerador
     * @return \StructType\ItemPagamento
     */
    public function setDataFatoGerador($dataFatoGerador = null)
    {
        // validation for constraint: string
        if (!is_null($dataFatoGerador) && !is_string($dataFatoGerador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataFatoGerador)), __LINE__);
        }
        $this->DataFatoGerador = $dataFatoGerador;
        return $this;
    }
    /**
     * Get DataVencimento value
     * @return string
     */
    public function getDataVencimento()
    {
        return $this->DataVencimento;
    }
    /**
     * Set DataVencimento value
     * @param string $dataVencimento
     * @return \StructType\ItemPagamento
     */
    public function setDataVencimento($dataVencimento = null)
    {
        // validation for constraint: string
        if (!is_null($dataVencimento) && !is_string($dataVencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataVencimento)), __LINE__);
        }
        $this->DataVencimento = $dataVencimento;
        return $this;
    }
    /**
     * Get DddContribuinte value
     * @return int
     */
    public function getDddContribuinte()
    {
        return $this->DddContribuinte;
    }
    /**
     * Set DddContribuinte value
     * @param int $dddContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setDddContribuinte($dddContribuinte = null)
    {
        // validation for constraint: int
        if (!is_null($dddContribuinte) && !is_numeric($dddContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dddContribuinte)), __LINE__);
        }
        $this->DddContribuinte = $dddContribuinte;
        return $this;
    }
    /**
     * Get DiaVencimento value
     * @return int
     */
    public function getDiaVencimento()
    {
        return $this->DiaVencimento;
    }
    /**
     * Set DiaVencimento value
     * @param int $diaVencimento
     * @return \StructType\ItemPagamento
     */
    public function setDiaVencimento($diaVencimento = null)
    {
        // validation for constraint: int
        if (!is_null($diaVencimento) && !is_numeric($diaVencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diaVencimento)), __LINE__);
        }
        $this->DiaVencimento = $diaVencimento;
        return $this;
    }
    /**
     * Get EnderecoContribuinte value
     * @return string
     */
    public function getEnderecoContribuinte()
    {
        return $this->EnderecoContribuinte;
    }
    /**
     * Set EnderecoContribuinte value
     * @param string $enderecoContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setEnderecoContribuinte($enderecoContribuinte = null)
    {
        // validation for constraint: string
        if (!is_null($enderecoContribuinte) && !is_string($enderecoContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enderecoContribuinte)), __LINE__);
        }
        $this->EnderecoContribuinte = $enderecoContribuinte;
        return $this;
    }
    /**
     * Get InformacoesComplementares value
     * @return string
     */
    public function getInformacoesComplementares()
    {
        return $this->InformacoesComplementares;
    }
    /**
     * Set InformacoesComplementares value
     * @param string $informacoesComplementares
     * @return \StructType\ItemPagamento
     */
    public function setInformacoesComplementares($informacoesComplementares = null)
    {
        // validation for constraint: string
        if (!is_null($informacoesComplementares) && !is_string($informacoesComplementares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informacoesComplementares)), __LINE__);
        }
        $this->InformacoesComplementares = $informacoesComplementares;
        return $this;
    }
    /**
     * Get InscEstadualRJ value
     * @return int
     */
    public function getInscEstadualRJ()
    {
        return $this->InscEstadualRJ;
    }
    /**
     * Set InscEstadualRJ value
     * @param int $inscEstadualRJ
     * @return \StructType\ItemPagamento
     */
    public function setInscEstadualRJ($inscEstadualRJ = null)
    {
        // validation for constraint: int
        if (!is_null($inscEstadualRJ) && !is_numeric($inscEstadualRJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inscEstadualRJ)), __LINE__);
        }
        $this->InscEstadualRJ = $inscEstadualRJ;
        return $this;
    }
    /**
     * Get MunicipioContribuinte value
     * @return string
     */
    public function getMunicipioContribuinte()
    {
        return $this->MunicipioContribuinte;
    }
    /**
     * Set MunicipioContribuinte value
     * @param string $municipioContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setMunicipioContribuinte($municipioContribuinte = null)
    {
        // validation for constraint: string
        if (!is_null($municipioContribuinte) && !is_string($municipioContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipioContribuinte)), __LINE__);
        }
        $this->MunicipioContribuinte = $municipioContribuinte;
        return $this;
    }
    /**
     * Get Natureza value
     * @return int
     */
    public function getNatureza()
    {
        return $this->Natureza;
    }
    /**
     * Set Natureza value
     * @param int $natureza
     * @return \StructType\ItemPagamento
     */
    public function setNatureza($natureza = null)
    {
        // validation for constraint: int
        if (!is_null($natureza) && !is_numeric($natureza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($natureza)), __LINE__);
        }
        $this->Natureza = $natureza;
        return $this;
    }
    /**
     * Get NaturezaQualificacao value
     * @return int
     */
    public function getNaturezaQualificacao()
    {
        return $this->NaturezaQualificacao;
    }
    /**
     * Set NaturezaQualificacao value
     * @param int $naturezaQualificacao
     * @return \StructType\ItemPagamento
     */
    public function setNaturezaQualificacao($naturezaQualificacao = null)
    {
        // validation for constraint: int
        if (!is_null($naturezaQualificacao) && !is_numeric($naturezaQualificacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($naturezaQualificacao)), __LINE__);
        }
        $this->NaturezaQualificacao = $naturezaQualificacao;
        return $this;
    }
    /**
     * Get NomeRazaoSocial value
     * @return string
     */
    public function getNomeRazaoSocial()
    {
        return $this->NomeRazaoSocial;
    }
    /**
     * Set NomeRazaoSocial value
     * @param string $nomeRazaoSocial
     * @return \StructType\ItemPagamento
     */
    public function setNomeRazaoSocial($nomeRazaoSocial = null)
    {
        // validation for constraint: string
        if (!is_null($nomeRazaoSocial) && !is_string($nomeRazaoSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeRazaoSocial)), __LINE__);
        }
        $this->NomeRazaoSocial = $nomeRazaoSocial;
        return $this;
    }
    /**
     * Get NotaFiscalCnpj value
     * @return int
     */
    public function getNotaFiscalCnpj()
    {
        return $this->NotaFiscalCnpj;
    }
    /**
     * Set NotaFiscalCnpj value
     * @param int $notaFiscalCnpj
     * @return \StructType\ItemPagamento
     */
    public function setNotaFiscalCnpj($notaFiscalCnpj = null)
    {
        // validation for constraint: int
        if (!is_null($notaFiscalCnpj) && !is_numeric($notaFiscalCnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notaFiscalCnpj)), __LINE__);
        }
        $this->NotaFiscalCnpj = $notaFiscalCnpj;
        return $this;
    }
    /**
     * Get NotaFiscalCpf value
     * @return int
     */
    public function getNotaFiscalCpf()
    {
        return $this->NotaFiscalCpf;
    }
    /**
     * Set NotaFiscalCpf value
     * @param int $notaFiscalCpf
     * @return \StructType\ItemPagamento
     */
    public function setNotaFiscalCpf($notaFiscalCpf = null)
    {
        // validation for constraint: int
        if (!is_null($notaFiscalCpf) && !is_numeric($notaFiscalCpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notaFiscalCpf)), __LINE__);
        }
        $this->NotaFiscalCpf = $notaFiscalCpf;
        return $this;
    }
    /**
     * Get NotaFiscalDataEmissao value
     * @return string
     */
    public function getNotaFiscalDataEmissao()
    {
        return $this->NotaFiscalDataEmissao;
    }
    /**
     * Set NotaFiscalDataEmissao value
     * @param string $notaFiscalDataEmissao
     * @return \StructType\ItemPagamento
     */
    public function setNotaFiscalDataEmissao($notaFiscalDataEmissao = null)
    {
        // validation for constraint: string
        if (!is_null($notaFiscalDataEmissao) && !is_string($notaFiscalDataEmissao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notaFiscalDataEmissao)), __LINE__);
        }
        $this->NotaFiscalDataEmissao = $notaFiscalDataEmissao;
        return $this;
    }
    /**
     * Get NotaFiscalNumero value
     * @return int
     */
    public function getNotaFiscalNumero()
    {
        return $this->NotaFiscalNumero;
    }
    /**
     * Set NotaFiscalNumero value
     * @param int $notaFiscalNumero
     * @return \StructType\ItemPagamento
     */
    public function setNotaFiscalNumero($notaFiscalNumero = null)
    {
        // validation for constraint: int
        if (!is_null($notaFiscalNumero) && !is_numeric($notaFiscalNumero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notaFiscalNumero)), __LINE__);
        }
        $this->NotaFiscalNumero = $notaFiscalNumero;
        return $this;
    }
    /**
     * Get NotaFiscalSerie value
     * @return int
     */
    public function getNotaFiscalSerie()
    {
        return $this->NotaFiscalSerie;
    }
    /**
     * Set NotaFiscalSerie value
     * @param int $notaFiscalSerie
     * @return \StructType\ItemPagamento
     */
    public function setNotaFiscalSerie($notaFiscalSerie = null)
    {
        // validation for constraint: int
        if (!is_null($notaFiscalSerie) && !is_numeric($notaFiscalSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notaFiscalSerie)), __LINE__);
        }
        $this->NotaFiscalSerie = $notaFiscalSerie;
        return $this;
    }
    /**
     * Get NotaFiscalTipo value
     * @return string
     */
    public function getNotaFiscalTipo()
    {
        return $this->NotaFiscalTipo;
    }
    /**
     * Set NotaFiscalTipo value
     * @param string $notaFiscalTipo
     * @return \StructType\ItemPagamento
     */
    public function setNotaFiscalTipo($notaFiscalTipo = null)
    {
        // validation for constraint: string
        if (!is_null($notaFiscalTipo) && !is_string($notaFiscalTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notaFiscalTipo)), __LINE__);
        }
        $this->NotaFiscalTipo = $notaFiscalTipo;
        return $this;
    }
    /**
     * Get NumControleContribuinte value
     * @return string
     */
    public function getNumControleContribuinte()
    {
        return $this->NumControleContribuinte;
    }
    /**
     * Set NumControleContribuinte value
     * @param string $numControleContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setNumControleContribuinte($numControleContribuinte = null)
    {
        // validation for constraint: string
        if (!is_null($numControleContribuinte) && !is_string($numControleContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numControleContribuinte)), __LINE__);
        }
        $this->NumControleContribuinte = $numControleContribuinte;
        return $this;
    }
    /**
     * Get NumDocOrigem value
     * @return int
     */
    public function getNumDocOrigem()
    {
        return $this->NumDocOrigem;
    }
    /**
     * Set NumDocOrigem value
     * @param int $numDocOrigem
     * @return \StructType\ItemPagamento
     */
    public function setNumDocOrigem($numDocOrigem = null)
    {
        // validation for constraint: int
        if (!is_null($numDocOrigem) && !is_numeric($numDocOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDocOrigem)), __LINE__);
        }
        $this->NumDocOrigem = $numDocOrigem;
        return $this;
    }
    /**
     * Get Passaporte value
     * @return string
     */
    public function getPassaporte()
    {
        return $this->Passaporte;
    }
    /**
     * Set Passaporte value
     * @param string $passaporte
     * @return \StructType\ItemPagamento
     */
    public function setPassaporte($passaporte = null)
    {
        // validation for constraint: string
        if (!is_null($passaporte) && !is_string($passaporte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passaporte)), __LINE__);
        }
        $this->Passaporte = $passaporte;
        return $this;
    }
    /**
     * Get PeriodoReferenciaAno value
     * @return int
     */
    public function getPeriodoReferenciaAno()
    {
        return $this->PeriodoReferenciaAno;
    }
    /**
     * Set PeriodoReferenciaAno value
     * @param int $periodoReferenciaAno
     * @return \StructType\ItemPagamento
     */
    public function setPeriodoReferenciaAno($periodoReferenciaAno = null)
    {
        // validation for constraint: int
        if (!is_null($periodoReferenciaAno) && !is_numeric($periodoReferenciaAno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodoReferenciaAno)), __LINE__);
        }
        $this->PeriodoReferenciaAno = $periodoReferenciaAno;
        return $this;
    }
    /**
     * Get PeriodoReferenciaDecendio value
     * @return int
     */
    public function getPeriodoReferenciaDecendio()
    {
        return $this->PeriodoReferenciaDecendio;
    }
    /**
     * Set PeriodoReferenciaDecendio value
     * @param int $periodoReferenciaDecendio
     * @return \StructType\ItemPagamento
     */
    public function setPeriodoReferenciaDecendio($periodoReferenciaDecendio = null)
    {
        // validation for constraint: int
        if (!is_null($periodoReferenciaDecendio) && !is_numeric($periodoReferenciaDecendio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodoReferenciaDecendio)), __LINE__);
        }
        $this->PeriodoReferenciaDecendio = $periodoReferenciaDecendio;
        return $this;
    }
    /**
     * Get PeriodoReferenciaMes value
     * @return int
     */
    public function getPeriodoReferenciaMes()
    {
        return $this->PeriodoReferenciaMes;
    }
    /**
     * Set PeriodoReferenciaMes value
     * @param int $periodoReferenciaMes
     * @return \StructType\ItemPagamento
     */
    public function setPeriodoReferenciaMes($periodoReferenciaMes = null)
    {
        // validation for constraint: int
        if (!is_null($periodoReferenciaMes) && !is_numeric($periodoReferenciaMes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodoReferenciaMes)), __LINE__);
        }
        $this->PeriodoReferenciaMes = $periodoReferenciaMes;
        return $this;
    }
    /**
     * Get TelefoneContribuinte value
     * @return int
     */
    public function getTelefoneContribuinte()
    {
        return $this->TelefoneContribuinte;
    }
    /**
     * Set TelefoneContribuinte value
     * @param int $telefoneContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setTelefoneContribuinte($telefoneContribuinte = null)
    {
        // validation for constraint: int
        if (!is_null($telefoneContribuinte) && !is_numeric($telefoneContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($telefoneContribuinte)), __LINE__);
        }
        $this->TelefoneContribuinte = $telefoneContribuinte;
        return $this;
    }
    /**
     * Get TipoApuracao value
     * @return int
     */
    public function getTipoApuracao()
    {
        return $this->TipoApuracao;
    }
    /**
     * Set TipoApuracao value
     * @param int $tipoApuracao
     * @return \StructType\ItemPagamento
     */
    public function setTipoApuracao($tipoApuracao = null)
    {
        // validation for constraint: int
        if (!is_null($tipoApuracao) && !is_numeric($tipoApuracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipoApuracao)), __LINE__);
        }
        $this->TipoApuracao = $tipoApuracao;
        return $this;
    }
    /**
     * Get TipoId value
     * @return int
     */
    public function getTipoId()
    {
        return $this->TipoId;
    }
    /**
     * Set TipoId value
     * @param int $tipoId
     * @return \StructType\ItemPagamento
     */
    public function setTipoId($tipoId = null)
    {
        // validation for constraint: int
        if (!is_null($tipoId) && !is_numeric($tipoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipoId)), __LINE__);
        }
        $this->TipoId = $tipoId;
        return $this;
    }
    /**
     * Get TipoImportacao value
     * @return int
     */
    public function getTipoImportacao()
    {
        return $this->TipoImportacao;
    }
    /**
     * Set TipoImportacao value
     * @param int $tipoImportacao
     * @return \StructType\ItemPagamento
     */
    public function setTipoImportacao($tipoImportacao = null)
    {
        // validation for constraint: int
        if (!is_null($tipoImportacao) && !is_numeric($tipoImportacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipoImportacao)), __LINE__);
        }
        $this->TipoImportacao = $tipoImportacao;
        return $this;
    }
    /**
     * Get TipoPeriodoApuracao value
     * @return string
     */
    public function getTipoPeriodoApuracao()
    {
        return $this->TipoPeriodoApuracao;
    }
    /**
     * Set TipoPeriodoApuracao value
     * @param string $tipoPeriodoApuracao
     * @return \StructType\ItemPagamento
     */
    public function setTipoPeriodoApuracao($tipoPeriodoApuracao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoPeriodoApuracao) && !is_string($tipoPeriodoApuracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoPeriodoApuracao)), __LINE__);
        }
        $this->TipoPeriodoApuracao = $tipoPeriodoApuracao;
        return $this;
    }
    /**
     * Get UfContribuinte value
     * @return string
     */
    public function getUfContribuinte()
    {
        return $this->UfContribuinte;
    }
    /**
     * Set UfContribuinte value
     * @param string $ufContribuinte
     * @return \StructType\ItemPagamento
     */
    public function setUfContribuinte($ufContribuinte = null)
    {
        // validation for constraint: string
        if (!is_null($ufContribuinte) && !is_string($ufContribuinte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ufContribuinte)), __LINE__);
        }
        $this->UfContribuinte = $ufContribuinte;
        return $this;
    }
    /**
     * Get ValorFECPPrincipal value
     * @return float
     */
    public function getValorFECPPrincipal()
    {
        return $this->ValorFECPPrincipal;
    }
    /**
     * Set ValorFECPPrincipal value
     * @param float $valorFECPPrincipal
     * @return \StructType\ItemPagamento
     */
    public function setValorFECPPrincipal($valorFECPPrincipal = null)
    {
        $this->ValorFECPPrincipal = $valorFECPPrincipal;
        return $this;
    }
    /**
     * Get ValorICMSPrincipal value
     * @return float
     */
    public function getValorICMSPrincipal()
    {
        return $this->ValorICMSPrincipal;
    }
    /**
     * Set ValorICMSPrincipal value
     * @param float $valorICMSPrincipal
     * @return \StructType\ItemPagamento
     */
    public function setValorICMSPrincipal($valorICMSPrincipal = null)
    {
        $this->ValorICMSPrincipal = $valorICMSPrincipal;
        return $this;
    }
    /**
     * Get ValorTotal value
     * @return float
     */
    public function getValorTotal()
    {
        return $this->ValorTotal;
    }
    /**
     * Set ValorTotal value
     * @param float $valorTotal
     * @return \StructType\ItemPagamento
     */
    public function setValorTotal($valorTotal = null)
    {
        $this->ValorTotal = $valorTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemPagamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
