<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoPrecatorio StructType
 * @subpackage Structs
 */
class DocumentoPrecatorio extends AbstractStructBase
{
    /**
     * The CnpjCpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CnpjCpf;
    /**
     * The DataPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The NomeRazaoSocial
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NomeRazaoSocial;
    /**
     * The NuPrecatorio
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NuPrecatorio;
    /**
     * The ValorBaseCalculo
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorBaseCalculo;
    /**
     * The ValorIRRF
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorIRRF;
    /**
     * Constructor method for DocumentoPrecatorio
     * @uses DocumentoPrecatorio::setCnpjCpf()
     * @uses DocumentoPrecatorio::setDataPagamento()
     * @uses DocumentoPrecatorio::setNomeRazaoSocial()
     * @uses DocumentoPrecatorio::setNuPrecatorio()
     * @uses DocumentoPrecatorio::setValorBaseCalculo()
     * @uses DocumentoPrecatorio::setValorIRRF()
     * @param string $cnpjCpf
     * @param string $dataPagamento
     * @param string $nomeRazaoSocial
     * @param string $nuPrecatorio
     * @param float $valorBaseCalculo
     * @param float $valorIRRF
     */
    public function __construct($cnpjCpf = null, $dataPagamento = null, $nomeRazaoSocial = null, $nuPrecatorio = null, $valorBaseCalculo = null, $valorIRRF = null)
    {
        $this
            ->setCnpjCpf($cnpjCpf)
            ->setDataPagamento($dataPagamento)
            ->setNomeRazaoSocial($nomeRazaoSocial)
            ->setNuPrecatorio($nuPrecatorio)
            ->setValorBaseCalculo($valorBaseCalculo)
            ->setValorIRRF($valorIRRF);
    }
    /**
     * Get CnpjCpf value
     * @return string
     */
    public function getCnpjCpf()
    {
        return $this->CnpjCpf;
    }
    /**
     * Set CnpjCpf value
     * @param string $cnpjCpf
     * @return \StructType\DocumentoPrecatorio
     */
    public function setCnpjCpf($cnpjCpf = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjCpf) && !is_string($cnpjCpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cnpjCpf)), __LINE__);
        }
        $this->CnpjCpf = $cnpjCpf;
        return $this;
    }
    /**
     * Get DataPagamento value
     * @return string
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\DocumentoPrecatorio
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get NomeRazaoSocial value
     * @return string
     */
    public function getNomeRazaoSocial()
    {
        return $this->NomeRazaoSocial;
    }
    /**
     * Set NomeRazaoSocial value
     * @param string $nomeRazaoSocial
     * @return \StructType\DocumentoPrecatorio
     */
    public function setNomeRazaoSocial($nomeRazaoSocial = null)
    {
        // validation for constraint: string
        if (!is_null($nomeRazaoSocial) && !is_string($nomeRazaoSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeRazaoSocial)), __LINE__);
        }
        $this->NomeRazaoSocial = $nomeRazaoSocial;
        return $this;
    }
    /**
     * Get NuPrecatorio value
     * @return string
     */
    public function getNuPrecatorio()
    {
        return $this->NuPrecatorio;
    }
    /**
     * Set NuPrecatorio value
     * @param string $nuPrecatorio
     * @return \StructType\DocumentoPrecatorio
     */
    public function setNuPrecatorio($nuPrecatorio = null)
    {
        // validation for constraint: string
        if (!is_null($nuPrecatorio) && !is_string($nuPrecatorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nuPrecatorio)), __LINE__);
        }
        $this->NuPrecatorio = $nuPrecatorio;
        return $this;
    }
    /**
     * Get ValorBaseCalculo value
     * @return float
     */
    public function getValorBaseCalculo()
    {
        return $this->ValorBaseCalculo;
    }
    /**
     * Set ValorBaseCalculo value
     * @param float $valorBaseCalculo
     * @return \StructType\DocumentoPrecatorio
     */
    public function setValorBaseCalculo($valorBaseCalculo = null)
    {
        $this->ValorBaseCalculo = $valorBaseCalculo;
        return $this;
    }
    /**
     * Get ValorIRRF value
     * @return float
     */
    public function getValorIRRF()
    {
        return $this->ValorIRRF;
    }
    /**
     * Set ValorIRRF value
     * @param float $valorIRRF
     * @return \StructType\DocumentoPrecatorio
     */
    public function setValorIRRF($valorIRRF = null)
    {
        $this->ValorIRRF = $valorIRRF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentoPrecatorio
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
