<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www1.fazenda.rj.gov.br/projetoGCTBradesco/br/gov/rj/sef/gct/webservice/GerarDocumentoArrecadacaoWS.jws?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www1.fazenda.rj.gov.br/projetoGCTBradesco/br/gov/rj/sef/gct/webservice/GerarDocumentoArrecadacaoWS.jws?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for enviarDadosAuto operation/method
 */
if ($enviar->enviarDadosAuto(new \StructType\EnviarDadosAuto()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for enviarDados operation/method
 */
if ($enviar->enviarDados(new \StructType\EnviarDados()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for enviarDadosCDI operation/method
 */
if ($enviar->enviarDadosCDI(new \StructType\EnviarDadosCDI()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for enviarDadosProcEspecial operation/method
 */
if ($enviar->enviarDadosProcEspecial(new \StructType\EnviarDadosProcEspecial()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for enviarDadosParcelamento operation/method
 */
if ($enviar->enviarDadosParcelamento(new \StructType\EnviarDadosParcelamento()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for enviarDadosITD operation/method
 */
if ($enviar->enviarDadosITD(new \StructType\EnviarDadosITD()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Sample call for enviarDadosPrecatorio operation/method
 */
if ($enviar->enviarDadosPrecatorio(new \StructType\EnviarDadosPrecatorio()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for consultarDados operation/method
 */
if ($consultar->consultarDados(new \StructType\ConsultarDados()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
