<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentosRetorno StructType
 * @subpackage Structs
 */
class DocumentosRetorno extends AbstractStructBase
{
    /**
     * The DataPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The ListaCodigoBarra
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ListaCodigoBarra;
    /**
     * The MsgInsercao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MsgInsercao;
    /**
     * The NossoNumeroSEFAZ
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NossoNumeroSEFAZ;
    /**
     * The ItensRetorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemPagamentoRetorno
     */
    public $ItensRetorno;
    /**
     * Constructor method for DocumentosRetorno
     * @uses DocumentosRetorno::setDataPagamento()
     * @uses DocumentosRetorno::setListaCodigoBarra()
     * @uses DocumentosRetorno::setMsgInsercao()
     * @uses DocumentosRetorno::setNossoNumeroSEFAZ()
     * @uses DocumentosRetorno::setItensRetorno()
     * @param string $dataPagamento
     * @param string $listaCodigoBarra
     * @param string $msgInsercao
     * @param string $nossoNumeroSEFAZ
     * @param \ArrayType\ArrayOfItemPagamentoRetorno $itensRetorno
     */
    public function __construct($dataPagamento = null, $listaCodigoBarra = null, $msgInsercao = null, $nossoNumeroSEFAZ = null, \ArrayType\ArrayOfItemPagamentoRetorno $itensRetorno = null)
    {
        $this
            ->setDataPagamento($dataPagamento)
            ->setListaCodigoBarra($listaCodigoBarra)
            ->setMsgInsercao($msgInsercao)
            ->setNossoNumeroSEFAZ($nossoNumeroSEFAZ)
            ->setItensRetorno($itensRetorno);
    }
    /**
     * Get DataPagamento value
     * @return string
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\DocumentosRetorno
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get ListaCodigoBarra value
     * @return string
     */
    public function getListaCodigoBarra()
    {
        return $this->ListaCodigoBarra;
    }
    /**
     * Set ListaCodigoBarra value
     * @param string $listaCodigoBarra
     * @return \StructType\DocumentosRetorno
     */
    public function setListaCodigoBarra($listaCodigoBarra = null)
    {
        // validation for constraint: string
        if (!is_null($listaCodigoBarra) && !is_string($listaCodigoBarra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listaCodigoBarra)), __LINE__);
        }
        $this->ListaCodigoBarra = $listaCodigoBarra;
        return $this;
    }
    /**
     * Get MsgInsercao value
     * @return string
     */
    public function getMsgInsercao()
    {
        return $this->MsgInsercao;
    }
    /**
     * Set MsgInsercao value
     * @param string $msgInsercao
     * @return \StructType\DocumentosRetorno
     */
    public function setMsgInsercao($msgInsercao = null)
    {
        // validation for constraint: string
        if (!is_null($msgInsercao) && !is_string($msgInsercao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msgInsercao)), __LINE__);
        }
        $this->MsgInsercao = $msgInsercao;
        return $this;
    }
    /**
     * Get NossoNumeroSEFAZ value
     * @return string
     */
    public function getNossoNumeroSEFAZ()
    {
        return $this->NossoNumeroSEFAZ;
    }
    /**
     * Set NossoNumeroSEFAZ value
     * @param string $nossoNumeroSEFAZ
     * @return \StructType\DocumentosRetorno
     */
    public function setNossoNumeroSEFAZ($nossoNumeroSEFAZ = null)
    {
        // validation for constraint: string
        if (!is_null($nossoNumeroSEFAZ) && !is_string($nossoNumeroSEFAZ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nossoNumeroSEFAZ)), __LINE__);
        }
        $this->NossoNumeroSEFAZ = $nossoNumeroSEFAZ;
        return $this;
    }
    /**
     * Get ItensRetorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemPagamentoRetorno|null
     */
    public function getItensRetorno()
    {
        return isset($this->ItensRetorno) ? $this->ItensRetorno : null;
    }
    /**
     * Set ItensRetorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemPagamentoRetorno $itensRetorno
     * @return \StructType\DocumentosRetorno
     */
    public function setItensRetorno(\ArrayType\ArrayOfItemPagamentoRetorno $itensRetorno = null)
    {
        if (is_null($itensRetorno) || (is_array($itensRetorno) && empty($itensRetorno))) {
            unset($this->ItensRetorno);
        } else {
            $this->ItensRetorno = $itensRetorno;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentosRetorno
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
