<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoProcEspecial StructType
 * @subpackage Structs
 */
class DocumentoProcEspecial extends AbstractStructBase
{
    /**
     * The DataPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The InscEstadual
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InscEstadual;
    /**
     * The Natureza
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Natureza;
    /**
     * The ItensPagamentos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemPagamentoICMS
     */
    public $ItensPagamentos;
    /**
     * Constructor method for DocumentoProcEspecial
     * @uses DocumentoProcEspecial::setDataPagamento()
     * @uses DocumentoProcEspecial::setInscEstadual()
     * @uses DocumentoProcEspecial::setNatureza()
     * @uses DocumentoProcEspecial::setItensPagamentos()
     * @param string $dataPagamento
     * @param int $inscEstadual
     * @param int $natureza
     * @param \ArrayType\ArrayOfItemPagamentoICMS $itensPagamentos
     */
    public function __construct($dataPagamento = null, $inscEstadual = null, $natureza = null, \ArrayType\ArrayOfItemPagamentoICMS $itensPagamentos = null)
    {
        $this
            ->setDataPagamento($dataPagamento)
            ->setInscEstadual($inscEstadual)
            ->setNatureza($natureza)
            ->setItensPagamentos($itensPagamentos);
    }
    /**
     * Get DataPagamento value
     * @return string
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\DocumentoProcEspecial
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get InscEstadual value
     * @return int
     */
    public function getInscEstadual()
    {
        return $this->InscEstadual;
    }
    /**
     * Set InscEstadual value
     * @param int $inscEstadual
     * @return \StructType\DocumentoProcEspecial
     */
    public function setInscEstadual($inscEstadual = null)
    {
        // validation for constraint: int
        if (!is_null($inscEstadual) && !is_numeric($inscEstadual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inscEstadual)), __LINE__);
        }
        $this->InscEstadual = $inscEstadual;
        return $this;
    }
    /**
     * Get Natureza value
     * @return int
     */
    public function getNatureza()
    {
        return $this->Natureza;
    }
    /**
     * Set Natureza value
     * @param int $natureza
     * @return \StructType\DocumentoProcEspecial
     */
    public function setNatureza($natureza = null)
    {
        // validation for constraint: int
        if (!is_null($natureza) && !is_numeric($natureza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($natureza)), __LINE__);
        }
        $this->Natureza = $natureza;
        return $this;
    }
    /**
     * Get ItensPagamentos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemPagamentoICMS|null
     */
    public function getItensPagamentos()
    {
        return isset($this->ItensPagamentos) ? $this->ItensPagamentos : null;
    }
    /**
     * Set ItensPagamentos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemPagamentoICMS $itensPagamentos
     * @return \StructType\DocumentoProcEspecial
     */
    public function setItensPagamentos(\ArrayType\ArrayOfItemPagamentoICMS $itensPagamentos = null)
    {
        if (is_null($itensPagamentos) || (is_array($itensPagamentos) && empty($itensPagamentos))) {
            unset($this->ItensPagamentos);
        } else {
            $this->ItensPagamentos = $itensPagamentos;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentoProcEspecial
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
