<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoAuto StructType
 * @subpackage Structs
 */
class DocumentoAuto extends AbstractStructBase
{
    /**
     * The CnpjCpf
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CnpjCpf;
    /**
     * The DataCiencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataCiencia;
    /**
     * The DataReferencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataReferencia;
    /**
     * The NumAutoInfracao
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NumAutoInfracao;
    /**
     * Constructor method for DocumentoAuto
     * @uses DocumentoAuto::setCnpjCpf()
     * @uses DocumentoAuto::setDataCiencia()
     * @uses DocumentoAuto::setDataReferencia()
     * @uses DocumentoAuto::setNumAutoInfracao()
     * @param string $cnpjCpf
     * @param string $dataCiencia
     * @param string $dataReferencia
     * @param string $numAutoInfracao
     */
    public function __construct($cnpjCpf = null, $dataCiencia = null, $dataReferencia = null, $numAutoInfracao = null)
    {
        $this
            ->setCnpjCpf($cnpjCpf)
            ->setDataCiencia($dataCiencia)
            ->setDataReferencia($dataReferencia)
            ->setNumAutoInfracao($numAutoInfracao);
    }
    /**
     * Get CnpjCpf value
     * @return string
     */
    public function getCnpjCpf()
    {
        return $this->CnpjCpf;
    }
    /**
     * Set CnpjCpf value
     * @param string $cnpjCpf
     * @return \StructType\DocumentoAuto
     */
    public function setCnpjCpf($cnpjCpf = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjCpf) && !is_string($cnpjCpf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cnpjCpf)), __LINE__);
        }
        $this->CnpjCpf = $cnpjCpf;
        return $this;
    }
    /**
     * Get DataCiencia value
     * @return string
     */
    public function getDataCiencia()
    {
        return $this->DataCiencia;
    }
    /**
     * Set DataCiencia value
     * @param string $dataCiencia
     * @return \StructType\DocumentoAuto
     */
    public function setDataCiencia($dataCiencia = null)
    {
        // validation for constraint: string
        if (!is_null($dataCiencia) && !is_string($dataCiencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataCiencia)), __LINE__);
        }
        $this->DataCiencia = $dataCiencia;
        return $this;
    }
    /**
     * Get DataReferencia value
     * @return string
     */
    public function getDataReferencia()
    {
        return $this->DataReferencia;
    }
    /**
     * Set DataReferencia value
     * @param string $dataReferencia
     * @return \StructType\DocumentoAuto
     */
    public function setDataReferencia($dataReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($dataReferencia) && !is_string($dataReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataReferencia)), __LINE__);
        }
        $this->DataReferencia = $dataReferencia;
        return $this;
    }
    /**
     * Get NumAutoInfracao value
     * @return string
     */
    public function getNumAutoInfracao()
    {
        return $this->NumAutoInfracao;
    }
    /**
     * Set NumAutoInfracao value
     * @param string $numAutoInfracao
     * @return \StructType\DocumentoAuto
     */
    public function setNumAutoInfracao($numAutoInfracao = null)
    {
        // validation for constraint: string
        if (!is_null($numAutoInfracao) && !is_string($numAutoInfracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numAutoInfracao)), __LINE__);
        }
        $this->NumAutoInfracao = $numAutoInfracao;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentoAuto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
