<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemPagamento ArrayType
 * Meta informations extracted from the WSDL
 * - type: open:ArrayOfItemPagamento
 * @subpackage Arrays
 */
class ArrayOfItemPagamento extends AbstractStructArrayBase
{
    /**
     * The ItemPagamento
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemPagamento[]
     */
    public $ItemPagamento;
    /**
     * Constructor method for ArrayOfItemPagamento
     * @uses ArrayOfItemPagamento::setItemPagamento()
     * @param \StructType\ItemPagamento[] $itemPagamento
     */
    public function __construct(array $itemPagamento = array())
    {
        $this
            ->setItemPagamento($itemPagamento);
    }
    /**
     * Get ItemPagamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemPagamento[]|null
     */
    public function getItemPagamento()
    {
        return isset($this->ItemPagamento) ? $this->ItemPagamento : null;
    }
    /**
     * Set ItemPagamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemPagamento[] $itemPagamento
     * @return \ArrayType\ArrayOfItemPagamento
     */
    public function setItemPagamento(array $itemPagamento = array())
    {
        foreach ($itemPagamento as $arrayOfItemPagamentoItemPagamentoItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemPagamentoItemPagamentoItem instanceof \StructType\ItemPagamento) {
                throw new \InvalidArgumentException(sprintf('The ItemPagamento property can only contain items of \StructType\ItemPagamento, "%s" given', is_object($arrayOfItemPagamentoItemPagamentoItem) ? get_class($arrayOfItemPagamentoItemPagamentoItem) : gettype($arrayOfItemPagamentoItemPagamentoItem)), __LINE__);
            }
        }
        if (is_null($itemPagamento) || (is_array($itemPagamento) && empty($itemPagamento))) {
            unset($this->ItemPagamento);
        } else {
            $this->ItemPagamento = $itemPagamento;
        }
        return $this;
    }
    /**
     * Add item to ItemPagamento value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemPagamento $item
     * @return \ArrayType\ArrayOfItemPagamento
     */
    public function addToItemPagamento(\StructType\ItemPagamento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemPagamento) {
            throw new \InvalidArgumentException(sprintf('The ItemPagamento property can only contain items of \StructType\ItemPagamento, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemPagamento[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemPagamento|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemPagamento|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemPagamento|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemPagamento|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemPagamento|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemPagamento
     */
    public function getAttributeName()
    {
        return 'ItemPagamento';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemPagamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
