<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://presoa.aragon.es:10058/SNT_DraftService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://presoa.aragon.es:10058/SNT_DraftService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new Service($options);
/**
 * Sample call for SNT_DraftService_addAttachmentByCSV operation/method
 */
if ($service->SNT_DraftService_addAttachmentByCSV(new AddAttachmentByCSV()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_createDraft operation/method
 */
if ($service->SNT_DraftService_createDraft(new CreateDraft()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_deleteAttachment operation/method
 */
if ($service->SNT_DraftService_deleteAttachment(new DeleteAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_getAttachmentList operation/method
 */
if ($service->SNT_DraftService_getAttachmentList(new GetAttachmentList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_getDraft operation/method
 */
if ($service->SNT_DraftService_getDraft(new GetDraft()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_getDraftList operation/method
 */
if ($service->SNT_DraftService_getDraftList(new GetDraftList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_issueNotification operation/method
 */
if ($service->SNT_DraftService_issueNotification(new IssueNotification()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_issueRegisterNotification operation/method
 */
if ($service->SNT_DraftService_issueRegisterNotification(new IssueRegisterNotification()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SNT_DraftService_updateDraft operation/method
 */
if ($service->SNT_DraftService_updateDraft(new UpdateDraft()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
