<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * SNT_DraftService_addAttachmentByCSV
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddAttachmentByCSV $addAttachmentByCSVRequestPart0
     * @return AddAttachmentByCSVResponse|bool
     */
    public function SNT_DraftService_addAttachmentByCSV(AddAttachmentByCSV $addAttachmentByCSVRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_addAttachmentByCSV($addAttachmentByCSVRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_createDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateDraft $createDraftRequestPart0
     * @return CreateDraftResponse|bool
     */
    public function SNT_DraftService_createDraft(CreateDraft $createDraftRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_createDraft($createDraftRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_deleteAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteAttachment $deleteAttachmentRequestPart0
     * @return DeleteAttachmentResponse|bool
     */
    public function SNT_DraftService_deleteAttachment(DeleteAttachment $deleteAttachmentRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_deleteAttachment($deleteAttachmentRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_getAttachmentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAttachmentList $getAttachmentListRequestPart0
     * @return GetAttachmentListResponse|bool
     */
    public function SNT_DraftService_getAttachmentList(GetAttachmentList $getAttachmentListRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_getAttachmentList($getAttachmentListRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_getDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDraft $getDraftRequestPart0
     * @return GetDraftResponse|bool
     */
    public function SNT_DraftService_getDraft(GetDraft $getDraftRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_getDraft($getDraftRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_getDraftList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetDraftList $getDraftListRequestPart0
     * @return GetDraftListResponse|bool
     */
    public function SNT_DraftService_getDraftList(GetDraftList $getDraftListRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_getDraftList($getDraftListRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_issueNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IssueNotification $issueNotificationRequestPart0
     * @return IssueNotificationResponse|bool
     */
    public function SNT_DraftService_issueNotification(IssueNotification $issueNotificationRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_issueNotification($issueNotificationRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SNT_DraftService_issueRegisterNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IssueRegisterNotification $issueRegisterNotificationRequestPart0
     * @return IssueRegisterNotificationResponse|bool
     */
    public function SNT_DraftService_issueRegisterNotification(IssueRegisterNotification $issueRegisterNotificationRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_issueRegisterNotification($issueRegisterNotificationRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_updateDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateDraft $updateDraftRequestPart0
     * @return UpdateDraftResponse|bool
     */
    public function SNT_DraftService_updateDraft(UpdateDraft $updateDraftRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_updateDraft($updateDraftRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return AddAttachmentByCSVResponse|CreateDraftResponse|DeleteAttachmentResponse|GetAttachmentListResponse|GetDraftListResponse|GetDraftResponse|IssueNotificationResponse|IssueRegisterNotificationResponse|UpdateDraftResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
