<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultGetAttachmentList StructType
 * @subpackage Structs
 */
class ResultGetAttachmentList extends AbstractStructBase
{
    /**
     * The documentAttachmentList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var DocumentAttachment[]
     */
    public $documentAttachmentList;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $size;
    /**
     * Constructor method for ResultGetAttachmentList
     * @uses ResultGetAttachmentList::setDocumentAttachmentList()
     * @uses ResultGetAttachmentList::setSize()
     * @param DocumentAttachment[] $documentAttachmentList
     * @param int $size
     */
    public function __construct(array $documentAttachmentList = array(), $size = null)
    {
        $this
            ->setDocumentAttachmentList($documentAttachmentList)
            ->setSize($size);
    }
    /**
     * Get documentAttachmentList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DocumentAttachment[]|null
     */
    public function getDocumentAttachmentList()
    {
        return isset($this->documentAttachmentList) ? $this->documentAttachmentList : null;
    }
    /**
     * Set documentAttachmentList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param DocumentAttachment[] $documentAttachmentList
     * @return ResultGetAttachmentList
     */
    public function setDocumentAttachmentList(array $documentAttachmentList = array())
    {
        foreach ($documentAttachmentList as $resultGetAttachmentListDocumentAttachmentListItem) {
            // validation for constraint: itemType
            if (!$resultGetAttachmentListDocumentAttachmentListItem instanceof DocumentAttachment) {
                throw new \InvalidArgumentException(sprintf('The documentAttachmentList property can only contain items of DocumentAttachment, "%s" given', is_object($resultGetAttachmentListDocumentAttachmentListItem) ? get_class($resultGetAttachmentListDocumentAttachmentListItem) : gettype($resultGetAttachmentListDocumentAttachmentListItem)), __LINE__);
            }
        }
        if (is_null($documentAttachmentList) || (is_array($documentAttachmentList) && empty($documentAttachmentList))) {
            unset($this->documentAttachmentList);
        } else {
            $this->documentAttachmentList = $documentAttachmentList;
        }
        return $this;
    }
    /**
     * Add item to documentAttachmentList value
     * @throws \InvalidArgumentException
     * @param DocumentAttachment $item
     * @return ResultGetAttachmentList
     */
    public function addToDocumentAttachmentList(DocumentAttachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentAttachment) {
            throw new \InvalidArgumentException(sprintf('The documentAttachmentList property can only contain items of DocumentAttachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->documentAttachmentList[] = $item;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return ResultGetAttachmentList
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ResultGetAttachmentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
