<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParamAddAttachmentByCSV StructType
 * @subpackage Structs
 */
class ParamAddAttachmentByCSV extends ParamBase
{
    /**
     * The draftId
     * @var int
     */
    public $draftId;
    /**
     * The attIdList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $attIdList;
    /**
     * Constructor method for ParamAddAttachmentByCSV
     * @uses ParamAddAttachmentByCSV::setDraftId()
     * @uses ParamAddAttachmentByCSV::setAttIdList()
     * @param int $draftId
     * @param string[] $attIdList
     */
    public function __construct($draftId = null, array $attIdList = array())
    {
        $this
            ->setDraftId($draftId)
            ->setAttIdList($attIdList);
    }
    /**
     * Get draftId value
     * @return int|null
     */
    public function getDraftId()
    {
        return $this->draftId;
    }
    /**
     * Set draftId value
     * @param int $draftId
     * @return ParamAddAttachmentByCSV
     */
    public function setDraftId($draftId = null)
    {
        // validation for constraint: int
        if (!is_null($draftId) && !is_numeric($draftId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($draftId)), __LINE__);
        }
        $this->draftId = $draftId;
        return $this;
    }
    /**
     * Get attIdList value
     * @return string[]|null
     */
    public function getAttIdList()
    {
        return $this->attIdList;
    }
    /**
     * Set attIdList value
     * @throws \InvalidArgumentException
     * @param string[] $attIdList
     * @return ParamAddAttachmentByCSV
     */
    public function setAttIdList(array $attIdList = array())
    {
        foreach ($attIdList as $paramAddAttachmentByCSVAttIdListItem) {
            // validation for constraint: itemType
            if (!is_string($paramAddAttachmentByCSVAttIdListItem)) {
                throw new \InvalidArgumentException(sprintf('The attIdList property can only contain items of string, "%s" given', is_object($paramAddAttachmentByCSVAttIdListItem) ? get_class($paramAddAttachmentByCSVAttIdListItem) : gettype($paramAddAttachmentByCSVAttIdListItem)), __LINE__);
            }
        }
        $this->attIdList = $attIdList;
        return $this;
    }
    /**
     * Add item to attIdList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return ParamAddAttachmentByCSV
     */
    public function addToAttIdList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The attIdList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attIdList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ParamAddAttachmentByCSV
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
