<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultGetDraftList StructType
 * @subpackage Structs
 */
class ResultGetDraftList extends AbstractStructBase
{
    /**
     * The draftList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var Draft[]
     */
    public $draftList;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $size;
    /**
     * Constructor method for ResultGetDraftList
     * @uses ResultGetDraftList::setDraftList()
     * @uses ResultGetDraftList::setSize()
     * @param Draft[] $draftList
     * @param int $size
     */
    public function __construct(array $draftList = array(), $size = null)
    {
        $this
            ->setDraftList($draftList)
            ->setSize($size);
    }
    /**
     * Get draftList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Draft[]|null
     */
    public function getDraftList()
    {
        return isset($this->draftList) ? $this->draftList : null;
    }
    /**
     * Set draftList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param Draft[] $draftList
     * @return ResultGetDraftList
     */
    public function setDraftList(array $draftList = array())
    {
        foreach ($draftList as $resultGetDraftListDraftListItem) {
            // validation for constraint: itemType
            if (!$resultGetDraftListDraftListItem instanceof Draft) {
                throw new \InvalidArgumentException(sprintf('The draftList property can only contain items of Draft, "%s" given', is_object($resultGetDraftListDraftListItem) ? get_class($resultGetDraftListDraftListItem) : gettype($resultGetDraftListDraftListItem)), __LINE__);
            }
        }
        if (is_null($draftList) || (is_array($draftList) && empty($draftList))) {
            unset($this->draftList);
        } else {
            $this->draftList = $draftList;
        }
        return $this;
    }
    /**
     * Add item to draftList value
     * @throws \InvalidArgumentException
     * @param Draft $item
     * @return ResultGetDraftList
     */
    public function addToDraftList(Draft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Draft) {
            throw new \InvalidArgumentException(sprintf('The draftList property can only contain items of Draft, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->draftList[] = $item;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return ResultGetDraftList
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ResultGetDraftList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
