<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParamBase StructType
 * @subpackage Structs
 */
class ParamBase extends AbstractStructBase
{
    /**
     * The applicationId
     * @var string
     */
    public $applicationId;
    /**
     * The invokingId
     * @var string
     */
    public $invokingId;
    /**
     * Constructor method for ParamBase
     * @uses ParamBase::setApplicationId()
     * @uses ParamBase::setInvokingId()
     * @param string $applicationId
     * @param string $invokingId
     */
    public function __construct($applicationId = null, $invokingId = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setInvokingId($invokingId);
    }
    /**
     * Get applicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return ParamBase
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Get invokingId value
     * @return string|null
     */
    public function getInvokingId()
    {
        return $this->invokingId;
    }
    /**
     * Set invokingId value
     * @param string $invokingId
     * @return ParamBase
     */
    public function setInvokingId($invokingId = null)
    {
        // validation for constraint: string
        if (!is_null($invokingId) && !is_string($invokingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invokingId)), __LINE__);
        }
        $this->invokingId = $invokingId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ParamBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
