<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DraftSearch StructType
 * @subpackage Structs
 */
class DraftSearch extends Draft
{
    /**
     * The sortColumn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sortColumn;
    /**
     * The ascending
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $ascending;
    /**
     * The fromIndex
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $fromIndex;
    /**
     * The toIndex
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $toIndex;
    /**
     * The minCreationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $minCreationDate;
    /**
     * The maxCreationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxCreationDate;
    /**
     * The minNotificationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $minNotificationDate;
    /**
     * The maxNotificationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxNotificationDate;
    /**
     * The minSignDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $minSignDate;
    /**
     * The maxSignDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxSignDate;
    /**
     * The minExpireDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $minExpireDate;
    /**
     * The maxExpireDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxExpireDate;
    /**
     * The stateList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $stateList;
    /**
     * The organismList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $organismList;
    /**
     * The receiverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $receiverId;
    /**
     * The anotherReceiverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $anotherReceiverId;
    /**
     * The typeReceiverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $typeReceiverId;
    /**
     * Constructor method for DraftSearch
     * @uses DraftSearch::setSortColumn()
     * @uses DraftSearch::setAscending()
     * @uses DraftSearch::setFromIndex()
     * @uses DraftSearch::setToIndex()
     * @uses DraftSearch::setMinCreationDate()
     * @uses DraftSearch::setMaxCreationDate()
     * @uses DraftSearch::setMinNotificationDate()
     * @uses DraftSearch::setMaxNotificationDate()
     * @uses DraftSearch::setMinSignDate()
     * @uses DraftSearch::setMaxSignDate()
     * @uses DraftSearch::setMinExpireDate()
     * @uses DraftSearch::setMaxExpireDate()
     * @uses DraftSearch::setStateList()
     * @uses DraftSearch::setOrganismList()
     * @uses DraftSearch::setReceiverId()
     * @uses DraftSearch::setAnotherReceiverId()
     * @uses DraftSearch::setTypeReceiverId()
     * @param string $sortColumn
     * @param bool $ascending
     * @param int $fromIndex
     * @param int $toIndex
     * @param string $minCreationDate
     * @param string $maxCreationDate
     * @param string $minNotificationDate
     * @param string $maxNotificationDate
     * @param string $minSignDate
     * @param string $maxSignDate
     * @param string $minExpireDate
     * @param string $maxExpireDate
     * @param int[] $stateList
     * @param string[] $organismList
     * @param string $receiverId
     * @param string[] $anotherReceiverId
     * @param int[] $typeReceiverId
     */
    public function __construct($sortColumn = null, $ascending = null, $fromIndex = null, $toIndex = null, $minCreationDate = null, $maxCreationDate = null, $minNotificationDate = null, $maxNotificationDate = null, $minSignDate = null, $maxSignDate = null, $minExpireDate = null, $maxExpireDate = null, array $stateList = array(), array $organismList = array(), $receiverId = null, array $anotherReceiverId = array(), array $typeReceiverId = array())
    {
        $this
            ->setSortColumn($sortColumn)
            ->setAscending($ascending)
            ->setFromIndex($fromIndex)
            ->setToIndex($toIndex)
            ->setMinCreationDate($minCreationDate)
            ->setMaxCreationDate($maxCreationDate)
            ->setMinNotificationDate($minNotificationDate)
            ->setMaxNotificationDate($maxNotificationDate)
            ->setMinSignDate($minSignDate)
            ->setMaxSignDate($maxSignDate)
            ->setMinExpireDate($minExpireDate)
            ->setMaxExpireDate($maxExpireDate)
            ->setStateList($stateList)
            ->setOrganismList($organismList)
            ->setReceiverId($receiverId)
            ->setAnotherReceiverId($anotherReceiverId)
            ->setTypeReceiverId($typeReceiverId);
    }
    /**
     * Get sortColumn value
     * @return string|null
     */
    public function getSortColumn()
    {
        return $this->sortColumn;
    }
    /**
     * Set sortColumn value
     * @param string $sortColumn
     * @return DraftSearch
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortColumn) && !is_string($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortColumn)), __LINE__);
        }
        $this->sortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get ascending value
     * @return bool|null
     */
    public function getAscending()
    {
        return $this->ascending;
    }
    /**
     * Set ascending value
     * @param bool $ascending
     * @return DraftSearch
     */
    public function setAscending($ascending = null)
    {
        // validation for constraint: boolean
        if (!is_null($ascending) && !is_bool($ascending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ascending)), __LINE__);
        }
        $this->ascending = $ascending;
        return $this;
    }
    /**
     * Get fromIndex value
     * @return int|null
     */
    public function getFromIndex()
    {
        return $this->fromIndex;
    }
    /**
     * Set fromIndex value
     * @param int $fromIndex
     * @return DraftSearch
     */
    public function setFromIndex($fromIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fromIndex) && !is_numeric($fromIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromIndex)), __LINE__);
        }
        $this->fromIndex = $fromIndex;
        return $this;
    }
    /**
     * Get toIndex value
     * @return int|null
     */
    public function getToIndex()
    {
        return $this->toIndex;
    }
    /**
     * Set toIndex value
     * @param int $toIndex
     * @return DraftSearch
     */
    public function setToIndex($toIndex = null)
    {
        // validation for constraint: int
        if (!is_null($toIndex) && !is_numeric($toIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toIndex)), __LINE__);
        }
        $this->toIndex = $toIndex;
        return $this;
    }
    /**
     * Get minCreationDate value
     * @return string|null
     */
    public function getMinCreationDate()
    {
        return $this->minCreationDate;
    }
    /**
     * Set minCreationDate value
     * @param string $minCreationDate
     * @return DraftSearch
     */
    public function setMinCreationDate($minCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($minCreationDate) && !is_string($minCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minCreationDate)), __LINE__);
        }
        $this->minCreationDate = $minCreationDate;
        return $this;
    }
    /**
     * Get maxCreationDate value
     * @return string|null
     */
    public function getMaxCreationDate()
    {
        return $this->maxCreationDate;
    }
    /**
     * Set maxCreationDate value
     * @param string $maxCreationDate
     * @return DraftSearch
     */
    public function setMaxCreationDate($maxCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxCreationDate) && !is_string($maxCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxCreationDate)), __LINE__);
        }
        $this->maxCreationDate = $maxCreationDate;
        return $this;
    }
    /**
     * Get minNotificationDate value
     * @return string|null
     */
    public function getMinNotificationDate()
    {
        return $this->minNotificationDate;
    }
    /**
     * Set minNotificationDate value
     * @param string $minNotificationDate
     * @return DraftSearch
     */
    public function setMinNotificationDate($minNotificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($minNotificationDate) && !is_string($minNotificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minNotificationDate)), __LINE__);
        }
        $this->minNotificationDate = $minNotificationDate;
        return $this;
    }
    /**
     * Get maxNotificationDate value
     * @return string|null
     */
    public function getMaxNotificationDate()
    {
        return $this->maxNotificationDate;
    }
    /**
     * Set maxNotificationDate value
     * @param string $maxNotificationDate
     * @return DraftSearch
     */
    public function setMaxNotificationDate($maxNotificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxNotificationDate) && !is_string($maxNotificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxNotificationDate)), __LINE__);
        }
        $this->maxNotificationDate = $maxNotificationDate;
        return $this;
    }
    /**
     * Get minSignDate value
     * @return string|null
     */
    public function getMinSignDate()
    {
        return $this->minSignDate;
    }
    /**
     * Set minSignDate value
     * @param string $minSignDate
     * @return DraftSearch
     */
    public function setMinSignDate($minSignDate = null)
    {
        // validation for constraint: string
        if (!is_null($minSignDate) && !is_string($minSignDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minSignDate)), __LINE__);
        }
        $this->minSignDate = $minSignDate;
        return $this;
    }
    /**
     * Get maxSignDate value
     * @return string|null
     */
    public function getMaxSignDate()
    {
        return $this->maxSignDate;
    }
    /**
     * Set maxSignDate value
     * @param string $maxSignDate
     * @return DraftSearch
     */
    public function setMaxSignDate($maxSignDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxSignDate) && !is_string($maxSignDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxSignDate)), __LINE__);
        }
        $this->maxSignDate = $maxSignDate;
        return $this;
    }
    /**
     * Get minExpireDate value
     * @return string|null
     */
    public function getMinExpireDate()
    {
        return $this->minExpireDate;
    }
    /**
     * Set minExpireDate value
     * @param string $minExpireDate
     * @return DraftSearch
     */
    public function setMinExpireDate($minExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($minExpireDate) && !is_string($minExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minExpireDate)), __LINE__);
        }
        $this->minExpireDate = $minExpireDate;
        return $this;
    }
    /**
     * Get maxExpireDate value
     * @return string|null
     */
    public function getMaxExpireDate()
    {
        return $this->maxExpireDate;
    }
    /**
     * Set maxExpireDate value
     * @param string $maxExpireDate
     * @return DraftSearch
     */
    public function setMaxExpireDate($maxExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxExpireDate) && !is_string($maxExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxExpireDate)), __LINE__);
        }
        $this->maxExpireDate = $maxExpireDate;
        return $this;
    }
    /**
     * Get stateList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getStateList()
    {
        return isset($this->stateList) ? $this->stateList : null;
    }
    /**
     * Set stateList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $stateList
     * @return DraftSearch
     */
    public function setStateList(array $stateList = array())
    {
        foreach ($stateList as $draftSearchStateListItem) {
            // validation for constraint: itemType
            if (!is_numeric($draftSearchStateListItem)) {
                throw new \InvalidArgumentException(sprintf('The stateList property can only contain items of long, "%s" given', is_object($draftSearchStateListItem) ? get_class($draftSearchStateListItem) : gettype($draftSearchStateListItem)), __LINE__);
            }
        }
        if (is_null($stateList) || (is_array($stateList) && empty($stateList))) {
            unset($this->stateList);
        } else {
            $this->stateList = $stateList;
        }
        return $this;
    }
    /**
     * Add item to stateList value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return DraftSearch
     */
    public function addToStateList($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The stateList property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stateList[] = $item;
        return $this;
    }
    /**
     * Get organismList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOrganismList()
    {
        return isset($this->organismList) ? $this->organismList : null;
    }
    /**
     * Set organismList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $organismList
     * @return DraftSearch
     */
    public function setOrganismList(array $organismList = array())
    {
        foreach ($organismList as $draftSearchOrganismListItem) {
            // validation for constraint: itemType
            if (!is_string($draftSearchOrganismListItem)) {
                throw new \InvalidArgumentException(sprintf('The organismList property can only contain items of string, "%s" given', is_object($draftSearchOrganismListItem) ? get_class($draftSearchOrganismListItem) : gettype($draftSearchOrganismListItem)), __LINE__);
            }
        }
        if (is_null($organismList) || (is_array($organismList) && empty($organismList))) {
            unset($this->organismList);
        } else {
            $this->organismList = $organismList;
        }
        return $this;
    }
    /**
     * Add item to organismList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return DraftSearch
     */
    public function addToOrganismList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The organismList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->organismList[] = $item;
        return $this;
    }
    /**
     * Get receiverId value
     * @return string|null
     */
    public function getReceiverId()
    {
        return $this->receiverId;
    }
    /**
     * Set receiverId value
     * @param string $receiverId
     * @return DraftSearch
     */
    public function setReceiverId($receiverId = null)
    {
        // validation for constraint: string
        if (!is_null($receiverId) && !is_string($receiverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverId)), __LINE__);
        }
        $this->receiverId = $receiverId;
        return $this;
    }
    /**
     * Get anotherReceiverId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAnotherReceiverId()
    {
        return isset($this->anotherReceiverId) ? $this->anotherReceiverId : null;
    }
    /**
     * Set anotherReceiverId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $anotherReceiverId
     * @return DraftSearch
     */
    public function setAnotherReceiverId(array $anotherReceiverId = array())
    {
        foreach ($anotherReceiverId as $draftSearchAnotherReceiverIdItem) {
            // validation for constraint: itemType
            if (!is_string($draftSearchAnotherReceiverIdItem)) {
                throw new \InvalidArgumentException(sprintf('The anotherReceiverId property can only contain items of string, "%s" given', is_object($draftSearchAnotherReceiverIdItem) ? get_class($draftSearchAnotherReceiverIdItem) : gettype($draftSearchAnotherReceiverIdItem)), __LINE__);
            }
        }
        if (is_null($anotherReceiverId) || (is_array($anotherReceiverId) && empty($anotherReceiverId))) {
            unset($this->anotherReceiverId);
        } else {
            $this->anotherReceiverId = $anotherReceiverId;
        }
        return $this;
    }
    /**
     * Add item to anotherReceiverId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return DraftSearch
     */
    public function addToAnotherReceiverId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The anotherReceiverId property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->anotherReceiverId[] = $item;
        return $this;
    }
    /**
     * Get typeReceiverId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getTypeReceiverId()
    {
        return isset($this->typeReceiverId) ? $this->typeReceiverId : null;
    }
    /**
     * Set typeReceiverId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $typeReceiverId
     * @return DraftSearch
     */
    public function setTypeReceiverId(array $typeReceiverId = array())
    {
        foreach ($typeReceiverId as $draftSearchTypeReceiverIdItem) {
            // validation for constraint: itemType
            if (!is_numeric($draftSearchTypeReceiverIdItem)) {
                throw new \InvalidArgumentException(sprintf('The typeReceiverId property can only contain items of int, "%s" given', is_object($draftSearchTypeReceiverIdItem) ? get_class($draftSearchTypeReceiverIdItem) : gettype($draftSearchTypeReceiverIdItem)), __LINE__);
            }
        }
        if (is_null($typeReceiverId) || (is_array($typeReceiverId) && empty($typeReceiverId))) {
            unset($this->typeReceiverId);
        } else {
            $this->typeReceiverId = $typeReceiverId;
        }
        return $this;
    }
    /**
     * Add item to typeReceiverId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return DraftSearch
     */
    public function addToTypeReceiverId($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The typeReceiverId property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->typeReceiverId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DraftSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
