<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParamIssueRegisterNotification StructType
 * @subpackage Structs
 */
class ParamIssueRegisterNotification extends ParamBase
{
    /**
     * The draftId
     * @var int
     */
    public $draftId;
    /**
     * The organismRegister
     * @var string
     */
    public $organismRegister;
    /**
     * The issuerId
     * @var string
     */
    public $issuerId;
    /**
     * Constructor method for ParamIssueRegisterNotification
     * @uses ParamIssueRegisterNotification::setDraftId()
     * @uses ParamIssueRegisterNotification::setOrganismRegister()
     * @uses ParamIssueRegisterNotification::setIssuerId()
     * @param int $draftId
     * @param string $organismRegister
     * @param string $issuerId
     */
    public function __construct($draftId = null, $organismRegister = null, $issuerId = null)
    {
        $this
            ->setDraftId($draftId)
            ->setOrganismRegister($organismRegister)
            ->setIssuerId($issuerId);
    }
    /**
     * Get draftId value
     * @return int|null
     */
    public function getDraftId()
    {
        return $this->draftId;
    }
    /**
     * Set draftId value
     * @param int $draftId
     * @return \StructType\ParamIssueRegisterNotification
     */
    public function setDraftId($draftId = null)
    {
        // validation for constraint: int
        if (!is_null($draftId) && !is_numeric($draftId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($draftId)), __LINE__);
        }
        $this->draftId = $draftId;
        return $this;
    }
    /**
     * Get organismRegister value
     * @return string|null
     */
    public function getOrganismRegister()
    {
        return $this->organismRegister;
    }
    /**
     * Set organismRegister value
     * @param string $organismRegister
     * @return \StructType\ParamIssueRegisterNotification
     */
    public function setOrganismRegister($organismRegister = null)
    {
        // validation for constraint: string
        if (!is_null($organismRegister) && !is_string($organismRegister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organismRegister)), __LINE__);
        }
        $this->organismRegister = $organismRegister;
        return $this;
    }
    /**
     * Get issuerId value
     * @return string|null
     */
    public function getIssuerId()
    {
        return $this->issuerId;
    }
    /**
     * Set issuerId value
     * @param string $issuerId
     * @return \StructType\ParamIssueRegisterNotification
     */
    public function setIssuerId($issuerId = null)
    {
        // validation for constraint: string
        if (!is_null($issuerId) && !is_string($issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerId)), __LINE__);
        }
        $this->issuerId = $issuerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParamIssueRegisterNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
