<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The creatorId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $creatorId;
    /**
     * The issuerId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $issuerId;
    /**
     * The reportCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reportCode;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $state;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $content;
    /**
     * The detachedSigned
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $detachedSigned;
    /**
     * The formatSignature
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $formatSignature;
    /**
     * The mimeType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mimeType;
    /**
     * The fileSize
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $fileSize;
    /**
     * The fileName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fileName;
    /**
     * The creationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $creationDate;
    /**
     * The notificationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $notificationDate;
    /**
     * The signDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $signDate;
    /**
     * The expireDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $expireDate;
    /**
     * The expireTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $expireTime;
    /**
     * The procedureCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $procedureCode;
    /**
     * The signerId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $signerId;
    /**
     * The finalReceiverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $finalReceiverId;
    /**
     * The horizontalProceduresCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $horizontalProceduresCodes;
    /**
     * The nonHorizontalProceduresCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $nonHorizontalProceduresCodes;
    /**
     * The orgListVisibility
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $orgListVisibility;
    /**
     * The invokingUserRole
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $invokingUserRole;
    /**
     * The organismCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $organismCode;
    /**
     * The specificDataList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Data[]
     */
    public $specificDataList;
    /**
     * The notificationReceiversList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NotificationReceiver[]
     */
    public $notificationReceiversList;
    /**
     * Constructor method for Notification
     * @uses Notification::setId()
     * @uses Notification::setCreatorId()
     * @uses Notification::setIssuerId()
     * @uses Notification::setReportCode()
     * @uses Notification::setState()
     * @uses Notification::setDescription()
     * @uses Notification::setContent()
     * @uses Notification::setDetachedSigned()
     * @uses Notification::setFormatSignature()
     * @uses Notification::setMimeType()
     * @uses Notification::setFileSize()
     * @uses Notification::setFileName()
     * @uses Notification::setCreationDate()
     * @uses Notification::setNotificationDate()
     * @uses Notification::setSignDate()
     * @uses Notification::setExpireDate()
     * @uses Notification::setExpireTime()
     * @uses Notification::setProcedureCode()
     * @uses Notification::setSignerId()
     * @uses Notification::setFinalReceiverId()
     * @uses Notification::setHorizontalProceduresCodes()
     * @uses Notification::setNonHorizontalProceduresCodes()
     * @uses Notification::setOrgListVisibility()
     * @uses Notification::setInvokingUserRole()
     * @uses Notification::setOrganismCode()
     * @uses Notification::setSpecificDataList()
     * @uses Notification::setNotificationReceiversList()
     * @param int $id
     * @param string $creatorId
     * @param string $issuerId
     * @param string $reportCode
     * @param int $state
     * @param string $description
     * @param string $content
     * @param string $detachedSigned
     * @param int $formatSignature
     * @param string $mimeType
     * @param int $fileSize
     * @param string $fileName
     * @param string $creationDate
     * @param string $notificationDate
     * @param string $signDate
     * @param string $expireDate
     * @param int $expireTime
     * @param string $procedureCode
     * @param string $signerId
     * @param string $finalReceiverId
     * @param string[] $horizontalProceduresCodes
     * @param string[] $nonHorizontalProceduresCodes
     * @param string[] $orgListVisibility
     * @param string $invokingUserRole
     * @param string $organismCode
     * @param \StructType\Data[] $specificDataList
     * @param \StructType\NotificationReceiver[] $notificationReceiversList
     */
    public function __construct($id = null, $creatorId = null, $issuerId = null, $reportCode = null, $state = null, $description = null, $content = null, $detachedSigned = null, $formatSignature = null, $mimeType = null, $fileSize = null, $fileName = null, $creationDate = null, $notificationDate = null, $signDate = null, $expireDate = null, $expireTime = null, $procedureCode = null, $signerId = null, $finalReceiverId = null, array $horizontalProceduresCodes = array(), array $nonHorizontalProceduresCodes = array(), array $orgListVisibility = array(), $invokingUserRole = null, $organismCode = null, array $specificDataList = array(), array $notificationReceiversList = array())
    {
        $this
            ->setId($id)
            ->setCreatorId($creatorId)
            ->setIssuerId($issuerId)
            ->setReportCode($reportCode)
            ->setState($state)
            ->setDescription($description)
            ->setContent($content)
            ->setDetachedSigned($detachedSigned)
            ->setFormatSignature($formatSignature)
            ->setMimeType($mimeType)
            ->setFileSize($fileSize)
            ->setFileName($fileName)
            ->setCreationDate($creationDate)
            ->setNotificationDate($notificationDate)
            ->setSignDate($signDate)
            ->setExpireDate($expireDate)
            ->setExpireTime($expireTime)
            ->setProcedureCode($procedureCode)
            ->setSignerId($signerId)
            ->setFinalReceiverId($finalReceiverId)
            ->setHorizontalProceduresCodes($horizontalProceduresCodes)
            ->setNonHorizontalProceduresCodes($nonHorizontalProceduresCodes)
            ->setOrgListVisibility($orgListVisibility)
            ->setInvokingUserRole($invokingUserRole)
            ->setOrganismCode($organismCode)
            ->setSpecificDataList($specificDataList)
            ->setNotificationReceiversList($notificationReceiversList);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Notification
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get creatorId value
     * @return string|null
     */
    public function getCreatorId()
    {
        return $this->creatorId;
    }
    /**
     * Set creatorId value
     * @param string $creatorId
     * @return \StructType\Notification
     */
    public function setCreatorId($creatorId = null)
    {
        // validation for constraint: string
        if (!is_null($creatorId) && !is_string($creatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creatorId)), __LINE__);
        }
        $this->creatorId = $creatorId;
        return $this;
    }
    /**
     * Get issuerId value
     * @return string|null
     */
    public function getIssuerId()
    {
        return $this->issuerId;
    }
    /**
     * Set issuerId value
     * @param string $issuerId
     * @return \StructType\Notification
     */
    public function setIssuerId($issuerId = null)
    {
        // validation for constraint: string
        if (!is_null($issuerId) && !is_string($issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerId)), __LINE__);
        }
        $this->issuerId = $issuerId;
        return $this;
    }
    /**
     * Get reportCode value
     * @return string|null
     */
    public function getReportCode()
    {
        return $this->reportCode;
    }
    /**
     * Set reportCode value
     * @param string $reportCode
     * @return \StructType\Notification
     */
    public function setReportCode($reportCode = null)
    {
        // validation for constraint: string
        if (!is_null($reportCode) && !is_string($reportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reportCode)), __LINE__);
        }
        $this->reportCode = $reportCode;
        return $this;
    }
    /**
     * Get state value
     * @return int|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param int $state
     * @return \StructType\Notification
     */
    public function setState($state = null)
    {
        // validation for constraint: int
        if (!is_null($state) && !is_numeric($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Notification
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\Notification
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get detachedSigned value
     * @return string|null
     */
    public function getDetachedSigned()
    {
        return $this->detachedSigned;
    }
    /**
     * Set detachedSigned value
     * @param string $detachedSigned
     * @return \StructType\Notification
     */
    public function setDetachedSigned($detachedSigned = null)
    {
        // validation for constraint: string
        if (!is_null($detachedSigned) && !is_string($detachedSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detachedSigned)), __LINE__);
        }
        $this->detachedSigned = $detachedSigned;
        return $this;
    }
    /**
     * Get formatSignature value
     * @return int|null
     */
    public function getFormatSignature()
    {
        return $this->formatSignature;
    }
    /**
     * Set formatSignature value
     * @param int $formatSignature
     * @return \StructType\Notification
     */
    public function setFormatSignature($formatSignature = null)
    {
        // validation for constraint: int
        if (!is_null($formatSignature) && !is_numeric($formatSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formatSignature)), __LINE__);
        }
        $this->formatSignature = $formatSignature;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \StructType\Notification
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get fileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * Set fileSize value
     * @param int $fileSize
     * @return \StructType\Notification
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !is_numeric($fileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileSize)), __LINE__);
        }
        $this->fileSize = $fileSize;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\Notification
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\Notification
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get notificationDate value
     * @return string|null
     */
    public function getNotificationDate()
    {
        return $this->notificationDate;
    }
    /**
     * Set notificationDate value
     * @param string $notificationDate
     * @return \StructType\Notification
     */
    public function setNotificationDate($notificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($notificationDate) && !is_string($notificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationDate)), __LINE__);
        }
        $this->notificationDate = $notificationDate;
        return $this;
    }
    /**
     * Get signDate value
     * @return string|null
     */
    public function getSignDate()
    {
        return $this->signDate;
    }
    /**
     * Set signDate value
     * @param string $signDate
     * @return \StructType\Notification
     */
    public function setSignDate($signDate = null)
    {
        // validation for constraint: string
        if (!is_null($signDate) && !is_string($signDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDate)), __LINE__);
        }
        $this->signDate = $signDate;
        return $this;
    }
    /**
     * Get expireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->expireDate;
    }
    /**
     * Set expireDate value
     * @param string $expireDate
     * @return \StructType\Notification
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->expireDate = $expireDate;
        return $this;
    }
    /**
     * Get expireTime value
     * @return int|null
     */
    public function getExpireTime()
    {
        return $this->expireTime;
    }
    /**
     * Set expireTime value
     * @param int $expireTime
     * @return \StructType\Notification
     */
    public function setExpireTime($expireTime = null)
    {
        // validation for constraint: int
        if (!is_null($expireTime) && !is_numeric($expireTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expireTime)), __LINE__);
        }
        $this->expireTime = $expireTime;
        return $this;
    }
    /**
     * Get procedureCode value
     * @return string|null
     */
    public function getProcedureCode()
    {
        return $this->procedureCode;
    }
    /**
     * Set procedureCode value
     * @param string $procedureCode
     * @return \StructType\Notification
     */
    public function setProcedureCode($procedureCode = null)
    {
        // validation for constraint: string
        if (!is_null($procedureCode) && !is_string($procedureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($procedureCode)), __LINE__);
        }
        $this->procedureCode = $procedureCode;
        return $this;
    }
    /**
     * Get signerId value
     * @return string|null
     */
    public function getSignerId()
    {
        return $this->signerId;
    }
    /**
     * Set signerId value
     * @param string $signerId
     * @return \StructType\Notification
     */
    public function setSignerId($signerId = null)
    {
        // validation for constraint: string
        if (!is_null($signerId) && !is_string($signerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signerId)), __LINE__);
        }
        $this->signerId = $signerId;
        return $this;
    }
    /**
     * Get finalReceiverId value
     * @return string|null
     */
    public function getFinalReceiverId()
    {
        return $this->finalReceiverId;
    }
    /**
     * Set finalReceiverId value
     * @param string $finalReceiverId
     * @return \StructType\Notification
     */
    public function setFinalReceiverId($finalReceiverId = null)
    {
        // validation for constraint: string
        if (!is_null($finalReceiverId) && !is_string($finalReceiverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finalReceiverId)), __LINE__);
        }
        $this->finalReceiverId = $finalReceiverId;
        return $this;
    }
    /**
     * Get horizontalProceduresCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getHorizontalProceduresCodes()
    {
        return isset($this->horizontalProceduresCodes) ? $this->horizontalProceduresCodes : null;
    }
    /**
     * Set horizontalProceduresCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $horizontalProceduresCodes
     * @return \StructType\Notification
     */
    public function setHorizontalProceduresCodes(array $horizontalProceduresCodes = array())
    {
        foreach ($horizontalProceduresCodes as $notificationHorizontalProceduresCodesItem) {
            // validation for constraint: itemType
            if (!is_string($notificationHorizontalProceduresCodesItem)) {
                throw new \InvalidArgumentException(sprintf('The horizontalProceduresCodes property can only contain items of string, "%s" given', is_object($notificationHorizontalProceduresCodesItem) ? get_class($notificationHorizontalProceduresCodesItem) : gettype($notificationHorizontalProceduresCodesItem)), __LINE__);
            }
        }
        if (is_null($horizontalProceduresCodes) || (is_array($horizontalProceduresCodes) && empty($horizontalProceduresCodes))) {
            unset($this->horizontalProceduresCodes);
        } else {
            $this->horizontalProceduresCodes = $horizontalProceduresCodes;
        }
        return $this;
    }
    /**
     * Add item to horizontalProceduresCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Notification
     */
    public function addToHorizontalProceduresCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The horizontalProceduresCodes property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->horizontalProceduresCodes[] = $item;
        return $this;
    }
    /**
     * Get nonHorizontalProceduresCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getNonHorizontalProceduresCodes()
    {
        return isset($this->nonHorizontalProceduresCodes) ? $this->nonHorizontalProceduresCodes : null;
    }
    /**
     * Set nonHorizontalProceduresCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $nonHorizontalProceduresCodes
     * @return \StructType\Notification
     */
    public function setNonHorizontalProceduresCodes(array $nonHorizontalProceduresCodes = array())
    {
        foreach ($nonHorizontalProceduresCodes as $notificationNonHorizontalProceduresCodesItem) {
            // validation for constraint: itemType
            if (!is_string($notificationNonHorizontalProceduresCodesItem)) {
                throw new \InvalidArgumentException(sprintf('The nonHorizontalProceduresCodes property can only contain items of string, "%s" given', is_object($notificationNonHorizontalProceduresCodesItem) ? get_class($notificationNonHorizontalProceduresCodesItem) : gettype($notificationNonHorizontalProceduresCodesItem)), __LINE__);
            }
        }
        if (is_null($nonHorizontalProceduresCodes) || (is_array($nonHorizontalProceduresCodes) && empty($nonHorizontalProceduresCodes))) {
            unset($this->nonHorizontalProceduresCodes);
        } else {
            $this->nonHorizontalProceduresCodes = $nonHorizontalProceduresCodes;
        }
        return $this;
    }
    /**
     * Add item to nonHorizontalProceduresCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Notification
     */
    public function addToNonHorizontalProceduresCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The nonHorizontalProceduresCodes property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->nonHorizontalProceduresCodes[] = $item;
        return $this;
    }
    /**
     * Get orgListVisibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOrgListVisibility()
    {
        return isset($this->orgListVisibility) ? $this->orgListVisibility : null;
    }
    /**
     * Set orgListVisibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $orgListVisibility
     * @return \StructType\Notification
     */
    public function setOrgListVisibility(array $orgListVisibility = array())
    {
        foreach ($orgListVisibility as $notificationOrgListVisibilityItem) {
            // validation for constraint: itemType
            if (!is_string($notificationOrgListVisibilityItem)) {
                throw new \InvalidArgumentException(sprintf('The orgListVisibility property can only contain items of string, "%s" given', is_object($notificationOrgListVisibilityItem) ? get_class($notificationOrgListVisibilityItem) : gettype($notificationOrgListVisibilityItem)), __LINE__);
            }
        }
        if (is_null($orgListVisibility) || (is_array($orgListVisibility) && empty($orgListVisibility))) {
            unset($this->orgListVisibility);
        } else {
            $this->orgListVisibility = $orgListVisibility;
        }
        return $this;
    }
    /**
     * Add item to orgListVisibility value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Notification
     */
    public function addToOrgListVisibility($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The orgListVisibility property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orgListVisibility[] = $item;
        return $this;
    }
    /**
     * Get invokingUserRole value
     * @return string|null
     */
    public function getInvokingUserRole()
    {
        return $this->invokingUserRole;
    }
    /**
     * Set invokingUserRole value
     * @param string $invokingUserRole
     * @return \StructType\Notification
     */
    public function setInvokingUserRole($invokingUserRole = null)
    {
        // validation for constraint: string
        if (!is_null($invokingUserRole) && !is_string($invokingUserRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invokingUserRole)), __LINE__);
        }
        $this->invokingUserRole = $invokingUserRole;
        return $this;
    }
    /**
     * Get organismCode value
     * @return string|null
     */
    public function getOrganismCode()
    {
        return $this->organismCode;
    }
    /**
     * Set organismCode value
     * @param string $organismCode
     * @return \StructType\Notification
     */
    public function setOrganismCode($organismCode = null)
    {
        // validation for constraint: string
        if (!is_null($organismCode) && !is_string($organismCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organismCode)), __LINE__);
        }
        $this->organismCode = $organismCode;
        return $this;
    }
    /**
     * Get specificDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Data[]|null
     */
    public function getSpecificDataList()
    {
        return isset($this->specificDataList) ? $this->specificDataList : null;
    }
    /**
     * Set specificDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $specificDataList
     * @return \StructType\Notification
     */
    public function setSpecificDataList(array $specificDataList = array())
    {
        foreach ($specificDataList as $notificationSpecificDataListItem) {
            // validation for constraint: itemType
            if (!$notificationSpecificDataListItem instanceof \StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The specificDataList property can only contain items of \StructType\Data, "%s" given', is_object($notificationSpecificDataListItem) ? get_class($notificationSpecificDataListItem) : gettype($notificationSpecificDataListItem)), __LINE__);
            }
        }
        if (is_null($specificDataList) || (is_array($specificDataList) && empty($specificDataList))) {
            unset($this->specificDataList);
        } else {
            $this->specificDataList = $specificDataList;
        }
        return $this;
    }
    /**
     * Add item to specificDataList value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Notification
     */
    public function addToSpecificDataList(\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The specificDataList property can only contain items of \StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->specificDataList[] = $item;
        return $this;
    }
    /**
     * Get notificationReceiversList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NotificationReceiver[]|null
     */
    public function getNotificationReceiversList()
    {
        return isset($this->notificationReceiversList) ? $this->notificationReceiversList : null;
    }
    /**
     * Set notificationReceiversList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NotificationReceiver[] $notificationReceiversList
     * @return \StructType\Notification
     */
    public function setNotificationReceiversList(array $notificationReceiversList = array())
    {
        foreach ($notificationReceiversList as $notificationNotificationReceiversListItem) {
            // validation for constraint: itemType
            if (!$notificationNotificationReceiversListItem instanceof \StructType\NotificationReceiver) {
                throw new \InvalidArgumentException(sprintf('The notificationReceiversList property can only contain items of \StructType\NotificationReceiver, "%s" given', is_object($notificationNotificationReceiversListItem) ? get_class($notificationNotificationReceiversListItem) : gettype($notificationNotificationReceiversListItem)), __LINE__);
            }
        }
        if (is_null($notificationReceiversList) || (is_array($notificationReceiversList) && empty($notificationReceiversList))) {
            unset($this->notificationReceiversList);
        } else {
            $this->notificationReceiversList = $notificationReceiversList;
        }
        return $this;
    }
    /**
     * Add item to notificationReceiversList value
     * @throws \InvalidArgumentException
     * @param \StructType\NotificationReceiver $item
     * @return \StructType\Notification
     */
    public function addToNotificationReceiversList(\StructType\NotificationReceiver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NotificationReceiver) {
            throw new \InvalidArgumentException(sprintf('The notificationReceiversList property can only contain items of \StructType\NotificationReceiver, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->notificationReceiversList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Notification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
