<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentAttachmentSearch StructType
 * @subpackage Structs
 */
class DocumentAttachmentSearch extends DocumentAttachment
{
    /**
     * The sortColumn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sortColumn;
    /**
     * The ascending
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $ascending;
    /**
     * The fromIndex
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $fromIndex;
    /**
     * The toIndex
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $toIndex;
    /**
     * The stateList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $stateList;
    /**
     * The typeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $typeList;
    /**
     * Constructor method for DocumentAttachmentSearch
     * @uses DocumentAttachmentSearch::setSortColumn()
     * @uses DocumentAttachmentSearch::setAscending()
     * @uses DocumentAttachmentSearch::setFromIndex()
     * @uses DocumentAttachmentSearch::setToIndex()
     * @uses DocumentAttachmentSearch::setStateList()
     * @uses DocumentAttachmentSearch::setTypeList()
     * @param string $sortColumn
     * @param bool $ascending
     * @param int $fromIndex
     * @param int $toIndex
     * @param int[] $stateList
     * @param int[] $typeList
     */
    public function __construct($sortColumn = null, $ascending = null, $fromIndex = null, $toIndex = null, array $stateList = array(), array $typeList = array())
    {
        $this
            ->setSortColumn($sortColumn)
            ->setAscending($ascending)
            ->setFromIndex($fromIndex)
            ->setToIndex($toIndex)
            ->setStateList($stateList)
            ->setTypeList($typeList);
    }
    /**
     * Get sortColumn value
     * @return string|null
     */
    public function getSortColumn()
    {
        return $this->sortColumn;
    }
    /**
     * Set sortColumn value
     * @param string $sortColumn
     * @return \StructType\DocumentAttachmentSearch
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortColumn) && !is_string($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortColumn)), __LINE__);
        }
        $this->sortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get ascending value
     * @return bool|null
     */
    public function getAscending()
    {
        return $this->ascending;
    }
    /**
     * Set ascending value
     * @param bool $ascending
     * @return \StructType\DocumentAttachmentSearch
     */
    public function setAscending($ascending = null)
    {
        // validation for constraint: boolean
        if (!is_null($ascending) && !is_bool($ascending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ascending)), __LINE__);
        }
        $this->ascending = $ascending;
        return $this;
    }
    /**
     * Get fromIndex value
     * @return int|null
     */
    public function getFromIndex()
    {
        return $this->fromIndex;
    }
    /**
     * Set fromIndex value
     * @param int $fromIndex
     * @return \StructType\DocumentAttachmentSearch
     */
    public function setFromIndex($fromIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fromIndex) && !is_numeric($fromIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromIndex)), __LINE__);
        }
        $this->fromIndex = $fromIndex;
        return $this;
    }
    /**
     * Get toIndex value
     * @return int|null
     */
    public function getToIndex()
    {
        return $this->toIndex;
    }
    /**
     * Set toIndex value
     * @param int $toIndex
     * @return \StructType\DocumentAttachmentSearch
     */
    public function setToIndex($toIndex = null)
    {
        // validation for constraint: int
        if (!is_null($toIndex) && !is_numeric($toIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toIndex)), __LINE__);
        }
        $this->toIndex = $toIndex;
        return $this;
    }
    /**
     * Get stateList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getStateList()
    {
        return isset($this->stateList) ? $this->stateList : null;
    }
    /**
     * Set stateList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $stateList
     * @return \StructType\DocumentAttachmentSearch
     */
    public function setStateList(array $stateList = array())
    {
        foreach ($stateList as $documentAttachmentSearchStateListItem) {
            // validation for constraint: itemType
            if (!is_numeric($documentAttachmentSearchStateListItem)) {
                throw new \InvalidArgumentException(sprintf('The stateList property can only contain items of long, "%s" given', is_object($documentAttachmentSearchStateListItem) ? get_class($documentAttachmentSearchStateListItem) : gettype($documentAttachmentSearchStateListItem)), __LINE__);
            }
        }
        if (is_null($stateList) || (is_array($stateList) && empty($stateList))) {
            unset($this->stateList);
        } else {
            $this->stateList = $stateList;
        }
        return $this;
    }
    /**
     * Add item to stateList value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\DocumentAttachmentSearch
     */
    public function addToStateList($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The stateList property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stateList[] = $item;
        return $this;
    }
    /**
     * Get typeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getTypeList()
    {
        return isset($this->typeList) ? $this->typeList : null;
    }
    /**
     * Set typeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $typeList
     * @return \StructType\DocumentAttachmentSearch
     */
    public function setTypeList(array $typeList = array())
    {
        foreach ($typeList as $documentAttachmentSearchTypeListItem) {
            // validation for constraint: itemType
            if (!is_numeric($documentAttachmentSearchTypeListItem)) {
                throw new \InvalidArgumentException(sprintf('The typeList property can only contain items of long, "%s" given', is_object($documentAttachmentSearchTypeListItem) ? get_class($documentAttachmentSearchTypeListItem) : gettype($documentAttachmentSearchTypeListItem)), __LINE__);
            }
        }
        if (is_null($typeList) || (is_array($typeList) && empty($typeList))) {
            unset($this->typeList);
        } else {
            $this->typeList = $typeList;
        }
        return $this;
    }
    /**
     * Add item to typeList value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\DocumentAttachmentSearch
     */
    public function addToTypeList($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The typeList property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->typeList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentAttachmentSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
