<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Communication StructType
 * @subpackage Structs
 */
class Communication extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The draftId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $draftId;
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $method;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $destination;
    /**
     * Constructor method for Communication
     * @uses Communication::setId()
     * @uses Communication::setDraftId()
     * @uses Communication::setMethod()
     * @uses Communication::setDestination()
     * @param int $id
     * @param int $draftId
     * @param int $method
     * @param string $destination
     */
    public function __construct($id = null, $draftId = null, $method = null, $destination = null)
    {
        $this
            ->setId($id)
            ->setDraftId($draftId)
            ->setMethod($method)
            ->setDestination($destination);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Communication
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get draftId value
     * @return int|null
     */
    public function getDraftId()
    {
        return $this->draftId;
    }
    /**
     * Set draftId value
     * @param int $draftId
     * @return \StructType\Communication
     */
    public function setDraftId($draftId = null)
    {
        // validation for constraint: int
        if (!is_null($draftId) && !is_numeric($draftId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($draftId)), __LINE__);
        }
        $this->draftId = $draftId;
        return $this;
    }
    /**
     * Get method value
     * @return int|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param int $method
     * @return \StructType\Communication
     */
    public function setMethod($method = null)
    {
        // validation for constraint: int
        if (!is_null($method) && !is_numeric($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\Communication
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Communication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
