<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SNTD ServiceType
 * @subpackage Services
 */
class SNTD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * SNT_DraftService_addAttachmentByCSV
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAttachmentByCSV $addAttachmentByCSVRequestPart0
     * @return \StructType\AddAttachmentByCSVResponse|bool
     */
    public function SNT_DraftService_addAttachmentByCSV(\StructType\AddAttachmentByCSV $addAttachmentByCSVRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_addAttachmentByCSV($addAttachmentByCSVRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_createDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateDraft $createDraftRequestPart0
     * @return \StructType\CreateDraftResponse|bool
     */
    public function SNT_DraftService_createDraft(\StructType\CreateDraft $createDraftRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_createDraft($createDraftRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_deleteAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteAttachment $deleteAttachmentRequestPart0
     * @return \StructType\DeleteAttachmentResponse|bool
     */
    public function SNT_DraftService_deleteAttachment(\StructType\DeleteAttachment $deleteAttachmentRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_deleteAttachment($deleteAttachmentRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_getAttachmentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttachmentList $getAttachmentListRequestPart0
     * @return \StructType\GetAttachmentListResponse|bool
     */
    public function SNT_DraftService_getAttachmentList(\StructType\GetAttachmentList $getAttachmentListRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_getAttachmentList($getAttachmentListRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_getDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDraft $getDraftRequestPart0
     * @return \StructType\GetDraftResponse|bool
     */
    public function SNT_DraftService_getDraft(\StructType\GetDraft $getDraftRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_getDraft($getDraftRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_getDraftList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDraftList $getDraftListRequestPart0
     * @return \StructType\GetDraftListResponse|bool
     */
    public function SNT_DraftService_getDraftList(\StructType\GetDraftList $getDraftListRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_getDraftList($getDraftListRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_issueNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IssueNotification $issueNotificationRequestPart0
     * @return \StructType\IssueNotificationResponse|bool
     */
    public function SNT_DraftService_issueNotification(\StructType\IssueNotification $issueNotificationRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_issueNotification($issueNotificationRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SNT_DraftService_issueRegisterNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IssueRegisterNotification $issueRegisterNotificationRequestPart0
     * @return \StructType\IssueRegisterNotificationResponse|bool
     */
    public function SNT_DraftService_issueRegisterNotification(\StructType\IssueRegisterNotification $issueRegisterNotificationRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_issueRegisterNotification($issueRegisterNotificationRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SNT_DraftService_updateDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDraft $updateDraftRequestPart0
     * @return \StructType\UpdateDraftResponse|bool
     */
    public function SNT_DraftService_updateDraft(\StructType\UpdateDraft $updateDraftRequestPart0)
    {
        try {
            $this->setResult(self::getSoapClient()->SNT_DraftService_updateDraft($updateDraftRequestPart0));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddAttachmentByCSVResponse|\StructType\CreateDraftResponse|\StructType\DeleteAttachmentResponse|\StructType\GetAttachmentListResponse|\StructType\GetDraftListResponse|\StructType\GetDraftResponse|\StructType\IssueNotificationResponse|\StructType\IssueRegisterNotificationResponse|\StructType\UpdateDraftResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
