<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ServicePyramid\ClassMap::get(),
);
/**
 * Samples for Data ServiceType
 */
$data = new \ServicePyramid\Services\Data($options);
/**
 * Sample call for SyncGoodsData operation/method
 */
if ($data->SyncGoodsData(new \ServicePyramid\Structs\SyncGoodsData()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Sample call for SyncGoodsWarehouseData operation/method
 */
if ($data->SyncGoodsWarehouseData(new \ServicePyramid\Structs\SyncGoodsWarehouseData()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Sample call for SyncCustomerData operation/method
 */
if ($data->SyncCustomerData(new \ServicePyramid\Structs\SyncCustomerData()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Sample call for SyncGroupsData operation/method
 */
if ($data->SyncGroupsData(new \ServicePyramid\Structs\SyncGroupsData()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Sample call for SyncGroupLabelsData operation/method
 */
if ($data->SyncGroupLabelsData(new \ServicePyramid\Structs\SyncGroupLabelsData()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Samples for Description ServiceType
 */
$description = new \ServicePyramid\Services\Description($options);
/**
 * Sample call for SyncGoodsDescription operation/method
 */
if ($description->SyncGoodsDescription(new \ServicePyramid\Structs\SyncGoodsDescription()) !== false) {
    print_r($description->getResult());
} else {
    print_r($description->getLastError());
}
/**
 * Samples for Orders ServiceType
 */
$orders = new \ServicePyramid\Services\Orders($options);
/**
 * Sample call for SyncOrders operation/method
 */
if ($orders->SyncOrders(new \ServicePyramid\Structs\SyncOrders()) !== false) {
    print_r($orders->getResult());
} else {
    print_r($orders->getLastError());
}
/**
 * Samples for Methods ServiceType
 */
$methods = new \ServicePyramid\Services\Methods($options);
/**
 * Sample call for SyncDeliveryMethods operation/method
 */
if ($methods->SyncDeliveryMethods(new \ServicePyramid\Structs\SyncDeliveryMethods()) !== false) {
    print_r($methods->getResult());
} else {
    print_r($methods->getLastError());
}
/**
 * Sample call for SyncPaymentMethods operation/method
 */
if ($methods->SyncPaymentMethods(new \ServicePyramid\Structs\SyncPaymentMethods()) !== false) {
    print_r($methods->getResult());
} else {
    print_r($methods->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \ServicePyramid\Services\Status($options);
/**
 * Sample call for ChangeOrderStatus operation/method
 */
if ($status->ChangeOrderStatus(new \ServicePyramid\Structs\ChangeOrderStatus()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServicePyramid\Services\Test($options);
/**
 * Sample call for WsTest operation/method
 */
if ($test->WsTest(new \ServicePyramid\Structs\WsTest()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Sales ServiceType
 */
$sales = new \ServicePyramid\Services\Sales($options);
/**
 * Sample call for GetMostSales operation/method
 */
if ($sales->GetMostSales(new \ServicePyramid\Structs\GetMostSales()) !== false) {
    print_r($sales->getResult());
} else {
    print_r($sales->getLastError());
}
