<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncGroupsData Structs
 * @subpackage Structs
 */
class SyncGroupsData extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Arrays\ArrayOfSyncGroup
     */
    public $groups;
    /**
     * Constructor method for SyncGroupsData
     * @uses SyncGroupsData::setUserName()
     * @uses SyncGroupsData::setPassword()
     * @uses SyncGroupsData::setGroups()
     * @param string $userName
     * @param string $password
     * @param \ServicePyramid\Arrays\ArrayOfSyncGroup $groups
     */
    public function __construct($userName = null, $password = null, \ServicePyramid\Arrays\ArrayOfSyncGroup $groups = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setGroups($groups);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \ServicePyramid\Structs\SyncGroupsData
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \ServicePyramid\Structs\SyncGroupsData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get groups value
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroup|null
     */
    public function getGroups()
    {
        return $this->groups;
    }
    /**
     * Set groups value
     * @param \ServicePyramid\Arrays\ArrayOfSyncGroup $groups
     * @return \ServicePyramid\Structs\SyncGroupsData
     */
    public function setGroups(\ServicePyramid\Arrays\ArrayOfSyncGroup $groups = null)
    {
        $this->groups = $groups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\SyncGroupsData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
