<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncGroupLabelsData Structs
 * @subpackage Structs
 */
class SyncGroupLabelsData extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The groupLabels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Arrays\ArrayOfSyncGroupLabels
     */
    public $groupLabels;
    /**
     * Constructor method for SyncGroupLabelsData
     * @uses SyncGroupLabelsData::setUserName()
     * @uses SyncGroupLabelsData::setPassword()
     * @uses SyncGroupLabelsData::setGroupLabels()
     * @param string $userName
     * @param string $password
     * @param \ServicePyramid\Arrays\ArrayOfSyncGroupLabels $groupLabels
     */
    public function __construct($userName = null, $password = null, \ServicePyramid\Arrays\ArrayOfSyncGroupLabels $groupLabels = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setGroupLabels($groupLabels);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \ServicePyramid\Structs\SyncGroupLabelsData
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \ServicePyramid\Structs\SyncGroupLabelsData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get groupLabels value
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroupLabels|null
     */
    public function getGroupLabels()
    {
        return $this->groupLabels;
    }
    /**
     * Set groupLabels value
     * @param \ServicePyramid\Arrays\ArrayOfSyncGroupLabels $groupLabels
     * @return \ServicePyramid\Structs\SyncGroupLabelsData
     */
    public function setGroupLabels(\ServicePyramid\Arrays\ArrayOfSyncGroupLabels $groupLabels = null)
    {
        $this->groupLabels = $groupLabels;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\SyncGroupLabelsData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
