<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasketDetail Structs
 * @subpackage Structs
 */
class BasketDetail extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The BasketId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BasketId;
    /**
     * The ConsumerPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumerPrice;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The WholesalePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WholesalePrice;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Qty;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Discount;
    /**
     * The HasDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasDiscount;
    /**
     * The GoodCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GoodCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Basket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Structs\Basket
     */
    public $Basket;
    /**
     * The ImagePath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImagePath;
    /**
     * The GoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GoodName;
    /**
     * The GroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * The GoodDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GoodDescription;
    /**
     * Constructor method for BasketDetail
     * @uses BasketDetail::setId()
     * @uses BasketDetail::setBasketId()
     * @uses BasketDetail::setConsumerPrice()
     * @uses BasketDetail::setPrice()
     * @uses BasketDetail::setWholesalePrice()
     * @uses BasketDetail::setQty()
     * @uses BasketDetail::setTotalPrice()
     * @uses BasketDetail::setDiscount()
     * @uses BasketDetail::setHasDiscount()
     * @uses BasketDetail::setGoodCode()
     * @uses BasketDetail::setDescription()
     * @uses BasketDetail::setBasket()
     * @uses BasketDetail::setImagePath()
     * @uses BasketDetail::setGoodName()
     * @uses BasketDetail::setGroupName()
     * @uses BasketDetail::setGoodDescription()
     * @param int $id
     * @param int $basketId
     * @param float $consumerPrice
     * @param float $price
     * @param float $wholesalePrice
     * @param int $qty
     * @param float $totalPrice
     * @param float $discount
     * @param bool $hasDiscount
     * @param string $goodCode
     * @param string $description
     * @param \ServicePyramid\Structs\Basket $basket
     * @param string $imagePath
     * @param string $goodName
     * @param string $groupName
     * @param string $goodDescription
     */
    public function __construct($id = null, $basketId = null, $consumerPrice = null, $price = null, $wholesalePrice = null, $qty = null, $totalPrice = null, $discount = null, $hasDiscount = null, $goodCode = null, $description = null, \ServicePyramid\Structs\Basket $basket = null, $imagePath = null, $goodName = null, $groupName = null, $goodDescription = null)
    {
        $this
            ->setId($id)
            ->setBasketId($basketId)
            ->setConsumerPrice($consumerPrice)
            ->setPrice($price)
            ->setWholesalePrice($wholesalePrice)
            ->setQty($qty)
            ->setTotalPrice($totalPrice)
            ->setDiscount($discount)
            ->setHasDiscount($hasDiscount)
            ->setGoodCode($goodCode)
            ->setDescription($description)
            ->setBasket($basket)
            ->setImagePath($imagePath)
            ->setGoodName($goodName)
            ->setGroupName($groupName)
            ->setGoodDescription($goodDescription);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get BasketId value
     * @return int
     */
    public function getBasketId()
    {
        return $this->BasketId;
    }
    /**
     * Set BasketId value
     * @param int $basketId
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setBasketId($basketId = null)
    {
        // validation for constraint: int
        if (!is_null($basketId) && !is_numeric($basketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($basketId)), __LINE__);
        }
        $this->BasketId = $basketId;
        return $this;
    }
    /**
     * Get ConsumerPrice value
     * @return float
     */
    public function getConsumerPrice()
    {
        return $this->ConsumerPrice;
    }
    /**
     * Set ConsumerPrice value
     * @param float $consumerPrice
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setConsumerPrice($consumerPrice = null)
    {
        $this->ConsumerPrice = $consumerPrice;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get WholesalePrice value
     * @return float
     */
    public function getWholesalePrice()
    {
        return $this->WholesalePrice;
    }
    /**
     * Set WholesalePrice value
     * @param float $wholesalePrice
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setWholesalePrice($wholesalePrice = null)
    {
        $this->WholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Get Qty value
     * @return int
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param int $qty
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !is_numeric($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setTotalPrice($totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setDiscount($discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get HasDiscount value
     * @return bool
     */
    public function getHasDiscount()
    {
        return $this->HasDiscount;
    }
    /**
     * Set HasDiscount value
     * @param bool $hasDiscount
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setHasDiscount($hasDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDiscount) && !is_bool($hasDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasDiscount)), __LINE__);
        }
        $this->HasDiscount = $hasDiscount;
        return $this;
    }
    /**
     * Get GoodCode value
     * @return string|null
     */
    public function getGoodCode()
    {
        return $this->GoodCode;
    }
    /**
     * Set GoodCode value
     * @param string $goodCode
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setGoodCode($goodCode = null)
    {
        // validation for constraint: string
        if (!is_null($goodCode) && !is_string($goodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodCode)), __LINE__);
        }
        $this->GoodCode = $goodCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Basket value
     * @return \ServicePyramid\Structs\Basket|null
     */
    public function getBasket()
    {
        return $this->Basket;
    }
    /**
     * Set Basket value
     * @param \ServicePyramid\Structs\Basket $basket
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setBasket(\ServicePyramid\Structs\Basket $basket = null)
    {
        $this->Basket = $basket;
        return $this;
    }
    /**
     * Get ImagePath value
     * @return string|null
     */
    public function getImagePath()
    {
        return $this->ImagePath;
    }
    /**
     * Set ImagePath value
     * @param string $imagePath
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setImagePath($imagePath = null)
    {
        // validation for constraint: string
        if (!is_null($imagePath) && !is_string($imagePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imagePath)), __LINE__);
        }
        $this->ImagePath = $imagePath;
        return $this;
    }
    /**
     * Get GoodName value
     * @return string|null
     */
    public function getGoodName()
    {
        return $this->GoodName;
    }
    /**
     * Set GoodName value
     * @param string $goodName
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setGoodName($goodName = null)
    {
        // validation for constraint: string
        if (!is_null($goodName) && !is_string($goodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodName)), __LINE__);
        }
        $this->GoodName = $goodName;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get GoodDescription value
     * @return string|null
     */
    public function getGoodDescription()
    {
        return $this->GoodDescription;
    }
    /**
     * Set GoodDescription value
     * @param string $goodDescription
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public function setGoodDescription($goodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($goodDescription) && !is_string($goodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodDescription)), __LINE__);
        }
        $this->GoodDescription = $goodDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\BasketDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
