<?php

namespace ServicePyramid\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status Services
 * @subpackage Services
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangeOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\ChangeOrderStatus $parameters
     * @return \ServicePyramid\Structs\ChangeOrderStatusResponse|bool
     */
    public function ChangeOrderStatus(\ServicePyramid\Structs\ChangeOrderStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChangeOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ServicePyramid\Structs\ChangeOrderStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
