<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncWarehouseProduct Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncWarehouseProduct extends AbstractStructArrayBase
{
    /**
     * The SyncWarehouseProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncWarehouseProduct[]
     */
    public $SyncWarehouseProduct;
    /**
     * Constructor method for ArrayOfSyncWarehouseProduct
     * @uses ArrayOfSyncWarehouseProduct::setSyncWarehouseProduct()
     * @param \ServicePyramid\Structs\SyncWarehouseProduct[] $syncWarehouseProduct
     */
    public function __construct(array $syncWarehouseProduct = array())
    {
        $this
            ->setSyncWarehouseProduct($syncWarehouseProduct);
    }
    /**
     * Get SyncWarehouseProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncWarehouseProduct[]|null
     */
    public function getSyncWarehouseProduct()
    {
        return isset($this->SyncWarehouseProduct) ? $this->SyncWarehouseProduct : null;
    }
    /**
     * Set SyncWarehouseProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncWarehouseProduct[] $syncWarehouseProduct
     * @return \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct
     */
    public function setSyncWarehouseProduct(array $syncWarehouseProduct = array())
    {
        foreach ($syncWarehouseProduct as $arrayOfSyncWarehouseProductSyncWarehouseProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncWarehouseProductSyncWarehouseProductItem instanceof \ServicePyramid\Structs\SyncWarehouseProduct) {
                throw new \InvalidArgumentException(sprintf('The SyncWarehouseProduct property can only contain items of \ServicePyramid\Structs\SyncWarehouseProduct, "%s" given', is_object($arrayOfSyncWarehouseProductSyncWarehouseProductItem) ? get_class($arrayOfSyncWarehouseProductSyncWarehouseProductItem) : gettype($arrayOfSyncWarehouseProductSyncWarehouseProductItem)), __LINE__);
            }
        }
        if (is_null($syncWarehouseProduct) || (is_array($syncWarehouseProduct) && empty($syncWarehouseProduct))) {
            unset($this->SyncWarehouseProduct);
        } else {
            $this->SyncWarehouseProduct = $syncWarehouseProduct;
        }
        return $this;
    }
    /**
     * Add item to SyncWarehouseProduct value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncWarehouseProduct $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct
     */
    public function addToSyncWarehouseProduct(\ServicePyramid\Structs\SyncWarehouseProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncWarehouseProduct) {
            throw new \InvalidArgumentException(sprintf('The SyncWarehouseProduct property can only contain items of \ServicePyramid\Structs\SyncWarehouseProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncWarehouseProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncWarehouseProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncWarehouseProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncWarehouseProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncWarehouseProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncWarehouseProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncWarehouseProduct
     */
    public function getAttributeName()
    {
        return 'SyncWarehouseProduct';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
