<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncResult Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncResult extends AbstractStructArrayBase
{
    /**
     * The SyncResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncResult[]
     */
    public $SyncResult;
    /**
     * Constructor method for ArrayOfSyncResult
     * @uses ArrayOfSyncResult::setSyncResult()
     * @param \ServicePyramid\Structs\SyncResult[] $syncResult
     */
    public function __construct(array $syncResult = array())
    {
        $this
            ->setSyncResult($syncResult);
    }
    /**
     * Get SyncResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncResult[]|null
     */
    public function getSyncResult()
    {
        return isset($this->SyncResult) ? $this->SyncResult : null;
    }
    /**
     * Set SyncResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncResult[] $syncResult
     * @return \ServicePyramid\Arrays\ArrayOfSyncResult
     */
    public function setSyncResult(array $syncResult = array())
    {
        foreach ($syncResult as $arrayOfSyncResultSyncResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncResultSyncResultItem instanceof \ServicePyramid\Structs\SyncResult) {
                throw new \InvalidArgumentException(sprintf('The SyncResult property can only contain items of \ServicePyramid\Structs\SyncResult, "%s" given', is_object($arrayOfSyncResultSyncResultItem) ? get_class($arrayOfSyncResultSyncResultItem) : gettype($arrayOfSyncResultSyncResultItem)), __LINE__);
            }
        }
        if (is_null($syncResult) || (is_array($syncResult) && empty($syncResult))) {
            unset($this->SyncResult);
        } else {
            $this->SyncResult = $syncResult;
        }
        return $this;
    }
    /**
     * Add item to SyncResult value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncResult $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncResult
     */
    public function addToSyncResult(\ServicePyramid\Structs\SyncResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncResult) {
            throw new \InvalidArgumentException(sprintf('The SyncResult property can only contain items of \ServicePyramid\Structs\SyncResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncResult
     */
    public function getAttributeName()
    {
        return 'SyncResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
