<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncGoods Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncGoods extends AbstractStructArrayBase
{
    /**
     * The SyncGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncGoods[]
     */
    public $SyncGoods;
    /**
     * Constructor method for ArrayOfSyncGoods
     * @uses ArrayOfSyncGoods::setSyncGoods()
     * @param \ServicePyramid\Structs\SyncGoods[] $syncGoods
     */
    public function __construct(array $syncGoods = array())
    {
        $this
            ->setSyncGoods($syncGoods);
    }
    /**
     * Get SyncGoods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncGoods[]|null
     */
    public function getSyncGoods()
    {
        return isset($this->SyncGoods) ? $this->SyncGoods : null;
    }
    /**
     * Set SyncGoods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGoods[] $syncGoods
     * @return \ServicePyramid\Arrays\ArrayOfSyncGoods
     */
    public function setSyncGoods(array $syncGoods = array())
    {
        foreach ($syncGoods as $arrayOfSyncGoodsSyncGoodsItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncGoodsSyncGoodsItem instanceof \ServicePyramid\Structs\SyncGoods) {
                throw new \InvalidArgumentException(sprintf('The SyncGoods property can only contain items of \ServicePyramid\Structs\SyncGoods, "%s" given', is_object($arrayOfSyncGoodsSyncGoodsItem) ? get_class($arrayOfSyncGoodsSyncGoodsItem) : gettype($arrayOfSyncGoodsSyncGoodsItem)), __LINE__);
            }
        }
        if (is_null($syncGoods) || (is_array($syncGoods) && empty($syncGoods))) {
            unset($this->SyncGoods);
        } else {
            $this->SyncGoods = $syncGoods;
        }
        return $this;
    }
    /**
     * Add item to SyncGoods value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGoods $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncGoods
     */
    public function addToSyncGoods(\ServicePyramid\Structs\SyncGoods $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncGoods) {
            throw new \InvalidArgumentException(sprintf('The SyncGoods property can only contain items of \ServicePyramid\Structs\SyncGoods, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncGoods[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncGoods|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncGoods|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncGoods|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncGoods|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncGoods|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncGoods
     */
    public function getAttributeName()
    {
        return 'SyncGoods';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncGoods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
