<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeliveryMethod Arrays
 * @subpackage Arrays
 */
class ArrayOfDeliveryMethod extends AbstractStructArrayBase
{
    /**
     * The DeliveryMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\DeliveryMethod[]
     */
    public $DeliveryMethod;
    /**
     * Constructor method for ArrayOfDeliveryMethod
     * @uses ArrayOfDeliveryMethod::setDeliveryMethod()
     * @param \ServicePyramid\Structs\DeliveryMethod[] $deliveryMethod
     */
    public function __construct(array $deliveryMethod = array())
    {
        $this
            ->setDeliveryMethod($deliveryMethod);
    }
    /**
     * Get DeliveryMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\DeliveryMethod[]|null
     */
    public function getDeliveryMethod()
    {
        return isset($this->DeliveryMethod) ? $this->DeliveryMethod : null;
    }
    /**
     * Set DeliveryMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\DeliveryMethod[] $deliveryMethod
     * @return \ServicePyramid\Arrays\ArrayOfDeliveryMethod
     */
    public function setDeliveryMethod(array $deliveryMethod = array())
    {
        foreach ($deliveryMethod as $arrayOfDeliveryMethodDeliveryMethodItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeliveryMethodDeliveryMethodItem instanceof \ServicePyramid\Structs\DeliveryMethod) {
                throw new \InvalidArgumentException(sprintf('The DeliveryMethod property can only contain items of \ServicePyramid\Structs\DeliveryMethod, "%s" given', is_object($arrayOfDeliveryMethodDeliveryMethodItem) ? get_class($arrayOfDeliveryMethodDeliveryMethodItem) : gettype($arrayOfDeliveryMethodDeliveryMethodItem)), __LINE__);
            }
        }
        if (is_null($deliveryMethod) || (is_array($deliveryMethod) && empty($deliveryMethod))) {
            unset($this->DeliveryMethod);
        } else {
            $this->DeliveryMethod = $deliveryMethod;
        }
        return $this;
    }
    /**
     * Add item to DeliveryMethod value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\DeliveryMethod $item
     * @return \ServicePyramid\Arrays\ArrayOfDeliveryMethod
     */
    public function addToDeliveryMethod(\ServicePyramid\Structs\DeliveryMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\DeliveryMethod) {
            throw new \InvalidArgumentException(sprintf('The DeliveryMethod property can only contain items of \ServicePyramid\Structs\DeliveryMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeliveryMethod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\DeliveryMethod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\DeliveryMethod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\DeliveryMethod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\DeliveryMethod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\DeliveryMethod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeliveryMethod
     */
    public function getAttributeName()
    {
        return 'DeliveryMethod';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfDeliveryMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
