<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncResult Structs
 * @subpackage Structs
 */
class SyncResult extends AbstractStructBase
{
    /**
     * The AutoId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoId;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for SyncResult
     * @uses SyncResult::setAutoId()
     * @uses SyncResult::setErrorMessage()
     * @param int $autoId
     * @param string $errorMessage
     */
    public function __construct($autoId = null, $errorMessage = null)
    {
        $this
            ->setAutoId($autoId)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get AutoId value
     * @return int
     */
    public function getAutoId()
    {
        return $this->AutoId;
    }
    /**
     * Set AutoId value
     * @param int $autoId
     * @return \ServicePyramid\Structs\SyncResult
     */
    public function setAutoId($autoId = null)
    {
        // validation for constraint: int
        if (!is_null($autoId) && !is_numeric($autoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoId)), __LINE__);
        }
        $this->AutoId = $autoId;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \ServicePyramid\Structs\SyncResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\SyncResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
