<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncGroupLabels Structs
 * @subpackage Structs
 */
class SyncGroupLabels extends GroupLabels
{
    /**
     * The AutoId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoId;
    /**
     * The SyncAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SyncAction;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The TableName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TableName;
    /**
     * The ChangedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangedValue;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for SyncGroupLabels
     * @uses SyncGroupLabels::setAutoId()
     * @uses SyncGroupLabels::setSyncAction()
     * @uses SyncGroupLabels::setDate()
     * @uses SyncGroupLabels::setTableName()
     * @uses SyncGroupLabels::setChangedValue()
     * @uses SyncGroupLabels::setValue()
     * @param int $autoId
     * @param string $syncAction
     * @param string $date
     * @param string $tableName
     * @param string $changedValue
     * @param string $value
     */
    public function __construct($autoId = null, $syncAction = null, $date = null, $tableName = null, $changedValue = null, $value = null)
    {
        $this
            ->setAutoId($autoId)
            ->setSyncAction($syncAction)
            ->setDate($date)
            ->setTableName($tableName)
            ->setChangedValue($changedValue)
            ->setValue($value);
    }
    /**
     * Get AutoId value
     * @return int
     */
    public function getAutoId()
    {
        return $this->AutoId;
    }
    /**
     * Set AutoId value
     * @param int $autoId
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public function setAutoId($autoId = null)
    {
        // validation for constraint: int
        if (!is_null($autoId) && !is_numeric($autoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoId)), __LINE__);
        }
        $this->AutoId = $autoId;
        return $this;
    }
    /**
     * Get SyncAction value
     * @return string
     */
    public function getSyncAction()
    {
        return $this->SyncAction;
    }
    /**
     * Set SyncAction value
     * @uses \ServicePyramid\Enums\SyncAction::valueIsValid()
     * @uses \ServicePyramid\Enums\SyncAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $syncAction
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public function setSyncAction($syncAction = null)
    {
        // validation for constraint: enumeration
        if (!\ServicePyramid\Enums\SyncAction::valueIsValid($syncAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $syncAction, implode(', ', \ServicePyramid\Enums\SyncAction::getValidValues())), __LINE__);
        }
        $this->SyncAction = $syncAction;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TableName value
     * @return string|null
     */
    public function getTableName()
    {
        return $this->TableName;
    }
    /**
     * Set TableName value
     * @param string $tableName
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public function setTableName($tableName = null)
    {
        // validation for constraint: string
        if (!is_null($tableName) && !is_string($tableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tableName)), __LINE__);
        }
        $this->TableName = $tableName;
        return $this;
    }
    /**
     * Get ChangedValue value
     * @return string|null
     */
    public function getChangedValue()
    {
        return $this->ChangedValue;
    }
    /**
     * Set ChangedValue value
     * @param string $changedValue
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public function setChangedValue($changedValue = null)
    {
        // validation for constraint: string
        if (!is_null($changedValue) && !is_string($changedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changedValue)), __LINE__);
        }
        $this->ChangedValue = $changedValue;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\SyncGroupLabels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
