<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncCustomer Structs
 * @subpackage Structs
 */
class SyncCustomer extends Customer
{
    /**
     * The AutoId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoId;
    /**
     * The SyncAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SyncAction;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The TableName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TableName;
    /**
     * The ChangedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangedValue;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The EMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMail;
    /**
     * The PasswordValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PasswordValue;
    /**
     * The UserNameValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserNameValue;
    /**
     * Constructor method for SyncCustomer
     * @uses SyncCustomer::setAutoId()
     * @uses SyncCustomer::setSyncAction()
     * @uses SyncCustomer::setDate()
     * @uses SyncCustomer::setTableName()
     * @uses SyncCustomer::setChangedValue()
     * @uses SyncCustomer::setValue()
     * @uses SyncCustomer::setEMail()
     * @uses SyncCustomer::setPasswordValue()
     * @uses SyncCustomer::setUserNameValue()
     * @param int $autoId
     * @param string $syncAction
     * @param string $date
     * @param string $tableName
     * @param string $changedValue
     * @param string $value
     * @param string $eMail
     * @param string $passwordValue
     * @param string $userNameValue
     */
    public function __construct($autoId = null, $syncAction = null, $date = null, $tableName = null, $changedValue = null, $value = null, $eMail = null, $passwordValue = null, $userNameValue = null)
    {
        $this
            ->setAutoId($autoId)
            ->setSyncAction($syncAction)
            ->setDate($date)
            ->setTableName($tableName)
            ->setChangedValue($changedValue)
            ->setValue($value)
            ->setEMail($eMail)
            ->setPasswordValue($passwordValue)
            ->setUserNameValue($userNameValue);
    }
    /**
     * Get AutoId value
     * @return int
     */
    public function getAutoId()
    {
        return $this->AutoId;
    }
    /**
     * Set AutoId value
     * @param int $autoId
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setAutoId($autoId = null)
    {
        // validation for constraint: int
        if (!is_null($autoId) && !is_numeric($autoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoId)), __LINE__);
        }
        $this->AutoId = $autoId;
        return $this;
    }
    /**
     * Get SyncAction value
     * @return string
     */
    public function getSyncAction()
    {
        return $this->SyncAction;
    }
    /**
     * Set SyncAction value
     * @uses \ServicePyramid\Enums\SyncAction::valueIsValid()
     * @uses \ServicePyramid\Enums\SyncAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $syncAction
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setSyncAction($syncAction = null)
    {
        // validation for constraint: enumeration
        if (!\ServicePyramid\Enums\SyncAction::valueIsValid($syncAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $syncAction, implode(', ', \ServicePyramid\Enums\SyncAction::getValidValues())), __LINE__);
        }
        $this->SyncAction = $syncAction;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TableName value
     * @return string|null
     */
    public function getTableName()
    {
        return $this->TableName;
    }
    /**
     * Set TableName value
     * @param string $tableName
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setTableName($tableName = null)
    {
        // validation for constraint: string
        if (!is_null($tableName) && !is_string($tableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tableName)), __LINE__);
        }
        $this->TableName = $tableName;
        return $this;
    }
    /**
     * Get ChangedValue value
     * @return string|null
     */
    public function getChangedValue()
    {
        return $this->ChangedValue;
    }
    /**
     * Set ChangedValue value
     * @param string $changedValue
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setChangedValue($changedValue = null)
    {
        // validation for constraint: string
        if (!is_null($changedValue) && !is_string($changedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changedValue)), __LINE__);
        }
        $this->ChangedValue = $changedValue;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get EMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param string $eMail
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMail)), __LINE__);
        }
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get PasswordValue value
     * @return string|null
     */
    public function getPasswordValue()
    {
        return $this->PasswordValue;
    }
    /**
     * Set PasswordValue value
     * @param string $passwordValue
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setPasswordValue($passwordValue = null)
    {
        // validation for constraint: string
        if (!is_null($passwordValue) && !is_string($passwordValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordValue)), __LINE__);
        }
        $this->PasswordValue = $passwordValue;
        return $this;
    }
    /**
     * Get UserNameValue value
     * @return string|null
     */
    public function getUserNameValue()
    {
        return $this->UserNameValue;
    }
    /**
     * Set UserNameValue value
     * @param string $userNameValue
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public function setUserNameValue($userNameValue = null)
    {
        // validation for constraint: string
        if (!is_null($userNameValue) && !is_string($userNameValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userNameValue)), __LINE__);
        }
        $this->UserNameValue = $userNameValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\SyncCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
