<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Basket Structs
 * @subpackage Structs
 */
class Basket extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserId;
    /**
     * The PaymentMethodId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentMethodId;
    /**
     * The DeliveryMethodId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryMethodId;
    /**
     * The InsertDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InsertDate;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The TotalConsumerPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumerPrice;
    /**
     * The TotalDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDiscount;
    /**
     * The DeliveryCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeliveryCost;
    /**
     * The TotalPayable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPayable;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The UserGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $UserGuid;
    /**
     * The CustomerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCode;
    /**
     * The StoreCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The NationalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NationalCode;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The PayReferenceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReferenceId;
    /**
     * The DeliveryTimeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTimeDescription;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Arrays\ArrayOfBasketDetail
     */
    public $Details;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Structs\DeliveryMethod
     */
    public $Delivery;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Structs\PaymentMethod
     */
    public $Payment;
    /**
     * Constructor method for Basket
     * @uses Basket::setId()
     * @uses Basket::setUserId()
     * @uses Basket::setPaymentMethodId()
     * @uses Basket::setDeliveryMethodId()
     * @uses Basket::setInsertDate()
     * @uses Basket::setTotalPrice()
     * @uses Basket::setTotalConsumerPrice()
     * @uses Basket::setTotalDiscount()
     * @uses Basket::setDeliveryCost()
     * @uses Basket::setTotalPayable()
     * @uses Basket::setStatus()
     * @uses Basket::setUserGuid()
     * @uses Basket::setCustomerCode()
     * @uses Basket::setStoreCode()
     * @uses Basket::setName()
     * @uses Basket::setAddress()
     * @uses Basket::setPhone()
     * @uses Basket::setMobile()
     * @uses Basket::setNationalCode()
     * @uses Basket::setPostalCode()
     * @uses Basket::setPayReferenceId()
     * @uses Basket::setDeliveryTimeDescription()
     * @uses Basket::setDetails()
     * @uses Basket::setDelivery()
     * @uses Basket::setPayment()
     * @param int $id
     * @param int $userId
     * @param int $paymentMethodId
     * @param int $deliveryMethodId
     * @param string $insertDate
     * @param float $totalPrice
     * @param float $totalConsumerPrice
     * @param float $totalDiscount
     * @param float $deliveryCost
     * @param float $totalPayable
     * @param string $status
     * @param string $userGuid
     * @param string $customerCode
     * @param string $storeCode
     * @param string $name
     * @param string $address
     * @param string $phone
     * @param string $mobile
     * @param string $nationalCode
     * @param string $postalCode
     * @param string $payReferenceId
     * @param string $deliveryTimeDescription
     * @param \ServicePyramid\Arrays\ArrayOfBasketDetail $details
     * @param \ServicePyramid\Structs\DeliveryMethod $delivery
     * @param \ServicePyramid\Structs\PaymentMethod $payment
     */
    public function __construct($id = null, $userId = null, $paymentMethodId = null, $deliveryMethodId = null, $insertDate = null, $totalPrice = null, $totalConsumerPrice = null, $totalDiscount = null, $deliveryCost = null, $totalPayable = null, $status = null, $userGuid = null, $customerCode = null, $storeCode = null, $name = null, $address = null, $phone = null, $mobile = null, $nationalCode = null, $postalCode = null, $payReferenceId = null, $deliveryTimeDescription = null, \ServicePyramid\Arrays\ArrayOfBasketDetail $details = null, \ServicePyramid\Structs\DeliveryMethod $delivery = null, \ServicePyramid\Structs\PaymentMethod $payment = null)
    {
        $this
            ->setId($id)
            ->setUserId($userId)
            ->setPaymentMethodId($paymentMethodId)
            ->setDeliveryMethodId($deliveryMethodId)
            ->setInsertDate($insertDate)
            ->setTotalPrice($totalPrice)
            ->setTotalConsumerPrice($totalConsumerPrice)
            ->setTotalDiscount($totalDiscount)
            ->setDeliveryCost($deliveryCost)
            ->setTotalPayable($totalPayable)
            ->setStatus($status)
            ->setUserGuid($userGuid)
            ->setCustomerCode($customerCode)
            ->setStoreCode($storeCode)
            ->setName($name)
            ->setAddress($address)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setNationalCode($nationalCode)
            ->setPostalCode($postalCode)
            ->setPayReferenceId($payReferenceId)
            ->setDeliveryTimeDescription($deliveryTimeDescription)
            ->setDetails($details)
            ->setDelivery($delivery)
            ->setPayment($payment);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \ServicePyramid\Structs\Basket
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get UserId value
     * @return int
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \ServicePyramid\Structs\Basket
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return int
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param int $paymentMethodId
     * @return \ServicePyramid\Structs\Basket
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMethodId) && !is_numeric($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentMethodId)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get DeliveryMethodId value
     * @return int
     */
    public function getDeliveryMethodId()
    {
        return $this->DeliveryMethodId;
    }
    /**
     * Set DeliveryMethodId value
     * @param int $deliveryMethodId
     * @return \ServicePyramid\Structs\Basket
     */
    public function setDeliveryMethodId($deliveryMethodId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryMethodId) && !is_numeric($deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryMethodId)), __LINE__);
        }
        $this->DeliveryMethodId = $deliveryMethodId;
        return $this;
    }
    /**
     * Get InsertDate value
     * @return string
     */
    public function getInsertDate()
    {
        return $this->InsertDate;
    }
    /**
     * Set InsertDate value
     * @param string $insertDate
     * @return \ServicePyramid\Structs\Basket
     */
    public function setInsertDate($insertDate = null)
    {
        // validation for constraint: string
        if (!is_null($insertDate) && !is_string($insertDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insertDate)), __LINE__);
        }
        $this->InsertDate = $insertDate;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \ServicePyramid\Structs\Basket
     */
    public function setTotalPrice($totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalConsumerPrice value
     * @return float
     */
    public function getTotalConsumerPrice()
    {
        return $this->TotalConsumerPrice;
    }
    /**
     * Set TotalConsumerPrice value
     * @param float $totalConsumerPrice
     * @return \ServicePyramid\Structs\Basket
     */
    public function setTotalConsumerPrice($totalConsumerPrice = null)
    {
        $this->TotalConsumerPrice = $totalConsumerPrice;
        return $this;
    }
    /**
     * Get TotalDiscount value
     * @return float
     */
    public function getTotalDiscount()
    {
        return $this->TotalDiscount;
    }
    /**
     * Set TotalDiscount value
     * @param float $totalDiscount
     * @return \ServicePyramid\Structs\Basket
     */
    public function setTotalDiscount($totalDiscount = null)
    {
        $this->TotalDiscount = $totalDiscount;
        return $this;
    }
    /**
     * Get DeliveryCost value
     * @return float
     */
    public function getDeliveryCost()
    {
        return $this->DeliveryCost;
    }
    /**
     * Set DeliveryCost value
     * @param float $deliveryCost
     * @return \ServicePyramid\Structs\Basket
     */
    public function setDeliveryCost($deliveryCost = null)
    {
        $this->DeliveryCost = $deliveryCost;
        return $this;
    }
    /**
     * Get TotalPayable value
     * @return float
     */
    public function getTotalPayable()
    {
        return $this->TotalPayable;
    }
    /**
     * Set TotalPayable value
     * @param float $totalPayable
     * @return \ServicePyramid\Structs\Basket
     */
    public function setTotalPayable($totalPayable = null)
    {
        $this->TotalPayable = $totalPayable;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \ServicePyramid\Enums\BasketStatus::valueIsValid()
     * @uses \ServicePyramid\Enums\BasketStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \ServicePyramid\Structs\Basket
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\ServicePyramid\Enums\BasketStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \ServicePyramid\Enums\BasketStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get UserGuid value
     * @return string
     */
    public function getUserGuid()
    {
        return $this->UserGuid;
    }
    /**
     * Set UserGuid value
     * @param string $userGuid
     * @return \ServicePyramid\Structs\Basket
     */
    public function setUserGuid($userGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($userGuid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($userGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userGuid) && !is_string($userGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userGuid)), __LINE__);
        }
        $this->UserGuid = $userGuid;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param string $customerCode
     * @return \ServicePyramid\Structs\Basket
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get StoreCode value
     * @return string|null
     */
    public function getStoreCode()
    {
        return $this->StoreCode;
    }
    /**
     * Set StoreCode value
     * @param string $storeCode
     * @return \ServicePyramid\Structs\Basket
     */
    public function setStoreCode($storeCode = null)
    {
        // validation for constraint: string
        if (!is_null($storeCode) && !is_string($storeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeCode)), __LINE__);
        }
        $this->StoreCode = $storeCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \ServicePyramid\Structs\Basket
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \ServicePyramid\Structs\Basket
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \ServicePyramid\Structs\Basket
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \ServicePyramid\Structs\Basket
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get NationalCode value
     * @return string|null
     */
    public function getNationalCode()
    {
        return $this->NationalCode;
    }
    /**
     * Set NationalCode value
     * @param string $nationalCode
     * @return \ServicePyramid\Structs\Basket
     */
    public function setNationalCode($nationalCode = null)
    {
        // validation for constraint: string
        if (!is_null($nationalCode) && !is_string($nationalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalCode)), __LINE__);
        }
        $this->NationalCode = $nationalCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \ServicePyramid\Structs\Basket
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get PayReferenceId value
     * @return string|null
     */
    public function getPayReferenceId()
    {
        return $this->PayReferenceId;
    }
    /**
     * Set PayReferenceId value
     * @param string $payReferenceId
     * @return \ServicePyramid\Structs\Basket
     */
    public function setPayReferenceId($payReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($payReferenceId) && !is_string($payReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payReferenceId)), __LINE__);
        }
        $this->PayReferenceId = $payReferenceId;
        return $this;
    }
    /**
     * Get DeliveryTimeDescription value
     * @return string|null
     */
    public function getDeliveryTimeDescription()
    {
        return $this->DeliveryTimeDescription;
    }
    /**
     * Set DeliveryTimeDescription value
     * @param string $deliveryTimeDescription
     * @return \ServicePyramid\Structs\Basket
     */
    public function setDeliveryTimeDescription($deliveryTimeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeDescription) && !is_string($deliveryTimeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryTimeDescription)), __LINE__);
        }
        $this->DeliveryTimeDescription = $deliveryTimeDescription;
        return $this;
    }
    /**
     * Get Details value
     * @return \ServicePyramid\Arrays\ArrayOfBasketDetail|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ServicePyramid\Arrays\ArrayOfBasketDetail $details
     * @return \ServicePyramid\Structs\Basket
     */
    public function setDetails(\ServicePyramid\Arrays\ArrayOfBasketDetail $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \ServicePyramid\Structs\DeliveryMethod|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \ServicePyramid\Structs\DeliveryMethod $delivery
     * @return \ServicePyramid\Structs\Basket
     */
    public function setDelivery(\ServicePyramid\Structs\DeliveryMethod $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get Payment value
     * @return \ServicePyramid\Structs\PaymentMethod|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \ServicePyramid\Structs\PaymentMethod $payment
     * @return \ServicePyramid\Structs\Basket
     */
    public function setPayment(\ServicePyramid\Structs\PaymentMethod $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\Basket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
