<?php

namespace ServicePyramid\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Orders Services
 * @subpackage Services
 */
class Orders extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SyncOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncOrders $parameters
     * @return \ServicePyramid\Structs\SyncOrdersResponse|bool
     */
    public function SyncOrders(\ServicePyramid\Structs\SyncOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ServicePyramid\Structs\SyncOrdersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
