<?php

namespace ServicePyramid\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Description Services
 * @subpackage Services
 */
class Description extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SyncGoodsDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncGoodsDescription $parameters
     * @return \ServicePyramid\Structs\SyncGoodsDescriptionResponse|bool
     */
    public function SyncGoodsDescription(\ServicePyramid\Structs\SyncGoodsDescription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncGoodsDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ServicePyramid\Structs\SyncGoodsDescriptionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
