<?php

namespace ServicePyramid\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Data Services
 * @subpackage Services
 */
class Data extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SyncGoodsData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncGoodsData $parameters
     * @return \ServicePyramid\Structs\SyncGoodsDataResponse|bool
     */
    public function SyncGoodsData(\ServicePyramid\Structs\SyncGoodsData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncGoodsData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SyncGoodsWarehouseData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncGoodsWarehouseData $parameters
     * @return \ServicePyramid\Structs\SyncGoodsWarehouseDataResponse|bool
     */
    public function SyncGoodsWarehouseData(\ServicePyramid\Structs\SyncGoodsWarehouseData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncGoodsWarehouseData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SyncCustomerData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncCustomerData $parameters
     * @return \ServicePyramid\Structs\SyncCustomerDataResponse|bool
     */
    public function SyncCustomerData(\ServicePyramid\Structs\SyncCustomerData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncCustomerData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SyncGroupsData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncGroupsData $parameters
     * @return \ServicePyramid\Structs\SyncGroupsDataResponse|bool
     */
    public function SyncGroupsData(\ServicePyramid\Structs\SyncGroupsData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncGroupsData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SyncGroupLabelsData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ServicePyramid\Structs\SyncGroupLabelsData $parameters
     * @return \ServicePyramid\Structs\SyncGroupLabelsDataResponse|bool
     */
    public function SyncGroupLabelsData(\ServicePyramid\Structs\SyncGroupLabelsData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SyncGroupLabelsData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ServicePyramid\Structs\SyncCustomerDataResponse|\ServicePyramid\Structs\SyncGoodsDataResponse|\ServicePyramid\Structs\SyncGoodsWarehouseDataResponse|\ServicePyramid\Structs\SyncGroupLabelsDataResponse|\ServicePyramid\Structs\SyncGroupsDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
