<?php

namespace ServicePyramid\Enums;

/**
 * This class stands for PaymentMethodType Enums
 * @subpackage Enumerations
 */
class PaymentMethodType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Internet'
     * @return string 'Internet'
     */
    const VALUE_INTERNET = 'Internet';
    /**
     * Constant for value 'Credit'
     * @return string 'Credit'
     */
    const VALUE_CREDIT = 'Credit';
    /**
     * Constant for value 'AtPlace'
     * @return string 'AtPlace'
     */
    const VALUE_AT_PLACE = 'AtPlace';
    /**
     * Constant for value 'CardToCard'
     * @return string 'CardToCard'
     */
    const VALUE_CARD_TO_CARD = 'CardToCard';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_INTERNET
     * @uses self::VALUE_CREDIT
     * @uses self::VALUE_AT_PLACE
     * @uses self::VALUE_CARD_TO_CARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_INTERNET,
            self::VALUE_CREDIT,
            self::VALUE_AT_PLACE,
            self::VALUE_CARD_TO_CARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
