<?php

namespace ServicePyramid\Enums;

/**
 * This class stands for DeliveryMethodType Enums
 * @subpackage Enumerations
 */
class DeliveryMethodType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Courier'
     * @return string 'Courier'
     */
    const VALUE_COURIER = 'Courier';
    /**
     * Constant for value 'Truck'
     * @return string 'Truck'
     */
    const VALUE_TRUCK = 'Truck';
    /**
     * Constant for value 'Post'
     * @return string 'Post'
     */
    const VALUE_POST = 'Post';
    /**
     * Constant for value 'Tipax'
     * @return string 'Tipax'
     */
    const VALUE_TIPAX = 'Tipax';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_COURIER
     * @uses self::VALUE_TRUCK
     * @uses self::VALUE_POST
     * @uses self::VALUE_TIPAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_COURIER,
            self::VALUE_TRUCK,
            self::VALUE_POST,
            self::VALUE_TIPAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
