<?php

namespace ServicePyramid\Enums;

/**
 * This class stands for BankServiceId Enums
 * @subpackage Enumerations
 */
class BankServiceId
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Mellat'
     * @return string 'Mellat'
     */
    const VALUE_MELLAT = 'Mellat';
    /**
     * Constant for value 'Assan'
     * @return string 'Assan'
     */
    const VALUE_ASSAN = 'Assan';
    /**
     * Constant for value 'Parsian'
     * @return string 'Parsian'
     */
    const VALUE_PARSIAN = 'Parsian';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_MELLAT
     * @uses self::VALUE_ASSAN
     * @uses self::VALUE_PARSIAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_MELLAT,
            self::VALUE_ASSAN,
            self::VALUE_PARSIAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
