<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncGroupLabels Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncGroupLabels extends AbstractStructArrayBase
{
    /**
     * The SyncGroupLabels
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncGroupLabels[]
     */
    public $SyncGroupLabels;
    /**
     * Constructor method for ArrayOfSyncGroupLabels
     * @uses ArrayOfSyncGroupLabels::setSyncGroupLabels()
     * @param \ServicePyramid\Structs\SyncGroupLabels[] $syncGroupLabels
     */
    public function __construct(array $syncGroupLabels = array())
    {
        $this
            ->setSyncGroupLabels($syncGroupLabels);
    }
    /**
     * Get SyncGroupLabels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncGroupLabels[]|null
     */
    public function getSyncGroupLabels()
    {
        return isset($this->SyncGroupLabels) ? $this->SyncGroupLabels : null;
    }
    /**
     * Set SyncGroupLabels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGroupLabels[] $syncGroupLabels
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroupLabels
     */
    public function setSyncGroupLabels(array $syncGroupLabels = array())
    {
        foreach ($syncGroupLabels as $arrayOfSyncGroupLabelsSyncGroupLabelsItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncGroupLabelsSyncGroupLabelsItem instanceof \ServicePyramid\Structs\SyncGroupLabels) {
                throw new \InvalidArgumentException(sprintf('The SyncGroupLabels property can only contain items of \ServicePyramid\Structs\SyncGroupLabels, "%s" given', is_object($arrayOfSyncGroupLabelsSyncGroupLabelsItem) ? get_class($arrayOfSyncGroupLabelsSyncGroupLabelsItem) : gettype($arrayOfSyncGroupLabelsSyncGroupLabelsItem)), __LINE__);
            }
        }
        if (is_null($syncGroupLabels) || (is_array($syncGroupLabels) && empty($syncGroupLabels))) {
            unset($this->SyncGroupLabels);
        } else {
            $this->SyncGroupLabels = $syncGroupLabels;
        }
        return $this;
    }
    /**
     * Add item to SyncGroupLabels value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGroupLabels $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroupLabels
     */
    public function addToSyncGroupLabels(\ServicePyramid\Structs\SyncGroupLabels $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncGroupLabels) {
            throw new \InvalidArgumentException(sprintf('The SyncGroupLabels property can only contain items of \ServicePyramid\Structs\SyncGroupLabels, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncGroupLabels[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncGroupLabels|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncGroupLabels|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncGroupLabels|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncGroupLabels|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncGroupLabels|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncGroupLabels
     */
    public function getAttributeName()
    {
        return 'SyncGroupLabels';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroupLabels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
