<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncGroup Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncGroup extends AbstractStructArrayBase
{
    /**
     * The SyncGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncGroup[]
     */
    public $SyncGroup;
    /**
     * Constructor method for ArrayOfSyncGroup
     * @uses ArrayOfSyncGroup::setSyncGroup()
     * @param \ServicePyramid\Structs\SyncGroup[] $syncGroup
     */
    public function __construct(array $syncGroup = array())
    {
        $this
            ->setSyncGroup($syncGroup);
    }
    /**
     * Get SyncGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncGroup[]|null
     */
    public function getSyncGroup()
    {
        return isset($this->SyncGroup) ? $this->SyncGroup : null;
    }
    /**
     * Set SyncGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGroup[] $syncGroup
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroup
     */
    public function setSyncGroup(array $syncGroup = array())
    {
        foreach ($syncGroup as $arrayOfSyncGroupSyncGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncGroupSyncGroupItem instanceof \ServicePyramid\Structs\SyncGroup) {
                throw new \InvalidArgumentException(sprintf('The SyncGroup property can only contain items of \ServicePyramid\Structs\SyncGroup, "%s" given', is_object($arrayOfSyncGroupSyncGroupItem) ? get_class($arrayOfSyncGroupSyncGroupItem) : gettype($arrayOfSyncGroupSyncGroupItem)), __LINE__);
            }
        }
        if (is_null($syncGroup) || (is_array($syncGroup) && empty($syncGroup))) {
            unset($this->SyncGroup);
        } else {
            $this->SyncGroup = $syncGroup;
        }
        return $this;
    }
    /**
     * Add item to SyncGroup value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGroup $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroup
     */
    public function addToSyncGroup(\ServicePyramid\Structs\SyncGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncGroup) {
            throw new \InvalidArgumentException(sprintf('The SyncGroup property can only contain items of \ServicePyramid\Structs\SyncGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncGroup
     */
    public function getAttributeName()
    {
        return 'SyncGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
