<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncGoodsDescription Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncGoodsDescription extends AbstractStructArrayBase
{
    /**
     * The SyncGoodsDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncGoodsDescription[]
     */
    public $SyncGoodsDescription;
    /**
     * Constructor method for ArrayOfSyncGoodsDescription
     * @uses ArrayOfSyncGoodsDescription::setSyncGoodsDescription()
     * @param \ServicePyramid\Structs\SyncGoodsDescription[] $syncGoodsDescription
     */
    public function __construct(array $syncGoodsDescription = array())
    {
        $this
            ->setSyncGoodsDescription($syncGoodsDescription);
    }
    /**
     * Get SyncGoodsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncGoodsDescription[]|null
     */
    public function getSyncGoodsDescription()
    {
        return isset($this->SyncGoodsDescription) ? $this->SyncGoodsDescription : null;
    }
    /**
     * Set SyncGoodsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGoodsDescription[] $syncGoodsDescription
     * @return \ServicePyramid\Arrays\ArrayOfSyncGoodsDescription
     */
    public function setSyncGoodsDescription(array $syncGoodsDescription = array())
    {
        foreach ($syncGoodsDescription as $arrayOfSyncGoodsDescriptionSyncGoodsDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncGoodsDescriptionSyncGoodsDescriptionItem instanceof \ServicePyramid\Structs\SyncGoodsDescription) {
                throw new \InvalidArgumentException(sprintf('The SyncGoodsDescription property can only contain items of \ServicePyramid\Structs\SyncGoodsDescription, "%s" given', is_object($arrayOfSyncGoodsDescriptionSyncGoodsDescriptionItem) ? get_class($arrayOfSyncGoodsDescriptionSyncGoodsDescriptionItem) : gettype($arrayOfSyncGoodsDescriptionSyncGoodsDescriptionItem)), __LINE__);
            }
        }
        if (is_null($syncGoodsDescription) || (is_array($syncGoodsDescription) && empty($syncGoodsDescription))) {
            unset($this->SyncGoodsDescription);
        } else {
            $this->SyncGoodsDescription = $syncGoodsDescription;
        }
        return $this;
    }
    /**
     * Add item to SyncGoodsDescription value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncGoodsDescription $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncGoodsDescription
     */
    public function addToSyncGoodsDescription(\ServicePyramid\Structs\SyncGoodsDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncGoodsDescription) {
            throw new \InvalidArgumentException(sprintf('The SyncGoodsDescription property can only contain items of \ServicePyramid\Structs\SyncGoodsDescription, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncGoodsDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncGoodsDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncGoodsDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncGoodsDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncGoodsDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncGoodsDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncGoodsDescription
     */
    public function getAttributeName()
    {
        return 'SyncGoodsDescription';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncGoodsDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
