<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSyncCustomer Arrays
 * @subpackage Arrays
 */
class ArrayOfSyncCustomer extends AbstractStructArrayBase
{
    /**
     * The SyncCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\SyncCustomer[]
     */
    public $SyncCustomer;
    /**
     * Constructor method for ArrayOfSyncCustomer
     * @uses ArrayOfSyncCustomer::setSyncCustomer()
     * @param \ServicePyramid\Structs\SyncCustomer[] $syncCustomer
     */
    public function __construct(array $syncCustomer = array())
    {
        $this
            ->setSyncCustomer($syncCustomer);
    }
    /**
     * Get SyncCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\SyncCustomer[]|null
     */
    public function getSyncCustomer()
    {
        return isset($this->SyncCustomer) ? $this->SyncCustomer : null;
    }
    /**
     * Set SyncCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncCustomer[] $syncCustomer
     * @return \ServicePyramid\Arrays\ArrayOfSyncCustomer
     */
    public function setSyncCustomer(array $syncCustomer = array())
    {
        foreach ($syncCustomer as $arrayOfSyncCustomerSyncCustomerItem) {
            // validation for constraint: itemType
            if (!$arrayOfSyncCustomerSyncCustomerItem instanceof \ServicePyramid\Structs\SyncCustomer) {
                throw new \InvalidArgumentException(sprintf('The SyncCustomer property can only contain items of \ServicePyramid\Structs\SyncCustomer, "%s" given', is_object($arrayOfSyncCustomerSyncCustomerItem) ? get_class($arrayOfSyncCustomerSyncCustomerItem) : gettype($arrayOfSyncCustomerSyncCustomerItem)), __LINE__);
            }
        }
        if (is_null($syncCustomer) || (is_array($syncCustomer) && empty($syncCustomer))) {
            unset($this->SyncCustomer);
        } else {
            $this->SyncCustomer = $syncCustomer;
        }
        return $this;
    }
    /**
     * Add item to SyncCustomer value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\SyncCustomer $item
     * @return \ServicePyramid\Arrays\ArrayOfSyncCustomer
     */
    public function addToSyncCustomer(\ServicePyramid\Structs\SyncCustomer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\SyncCustomer) {
            throw new \InvalidArgumentException(sprintf('The SyncCustomer property can only contain items of \ServicePyramid\Structs\SyncCustomer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SyncCustomer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\SyncCustomer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\SyncCustomer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\SyncCustomer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\SyncCustomer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\SyncCustomer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SyncCustomer
     */
    public function getAttributeName()
    {
        return 'SyncCustomer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfSyncCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
