<?php

namespace ServicePyramid\Arrays;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentMethod Arrays
 * @subpackage Arrays
 */
class ArrayOfPaymentMethod extends AbstractStructArrayBase
{
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ServicePyramid\Structs\PaymentMethod[]
     */
    public $PaymentMethod;
    /**
     * Constructor method for ArrayOfPaymentMethod
     * @uses ArrayOfPaymentMethod::setPaymentMethod()
     * @param \ServicePyramid\Structs\PaymentMethod[] $paymentMethod
     */
    public function __construct(array $paymentMethod = array())
    {
        $this
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ServicePyramid\Structs\PaymentMethod[]|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\PaymentMethod[] $paymentMethod
     * @return \ServicePyramid\Arrays\ArrayOfPaymentMethod
     */
    public function setPaymentMethod(array $paymentMethod = array())
    {
        foreach ($paymentMethod as $arrayOfPaymentMethodPaymentMethodItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentMethodPaymentMethodItem instanceof \ServicePyramid\Structs\PaymentMethod) {
                throw new \InvalidArgumentException(sprintf('The PaymentMethod property can only contain items of \ServicePyramid\Structs\PaymentMethod, "%s" given', is_object($arrayOfPaymentMethodPaymentMethodItem) ? get_class($arrayOfPaymentMethodPaymentMethodItem) : gettype($arrayOfPaymentMethodPaymentMethodItem)), __LINE__);
            }
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Add item to PaymentMethod value
     * @throws \InvalidArgumentException
     * @param \ServicePyramid\Structs\PaymentMethod $item
     * @return \ServicePyramid\Arrays\ArrayOfPaymentMethod
     */
    public function addToPaymentMethod(\ServicePyramid\Structs\PaymentMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ServicePyramid\Structs\PaymentMethod) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethod property can only contain items of \ServicePyramid\Structs\PaymentMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentMethod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ServicePyramid\Structs\PaymentMethod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ServicePyramid\Structs\PaymentMethod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ServicePyramid\Structs\PaymentMethod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ServicePyramid\Structs\PaymentMethod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ServicePyramid\Structs\PaymentMethod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentMethod
     */
    public function getAttributeName()
    {
        return 'PaymentMethod';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Arrays\ArrayOfPaymentMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
