<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseProduct Structs
 * @subpackage Structs
 */
class WarehouseProduct extends AbstractStructBase
{
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Qty;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The ConsumerPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumerPrice;
    /**
     * The WholesalePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WholesalePrice;
    /**
     * The QtyMin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyMin;
    /**
     * The QtyMax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyMax;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The WearhouseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WearhouseCode;
    /**
     * The GoodCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GoodCode;
    /**
     * Constructor method for WarehouseProduct
     * @uses WarehouseProduct::setQty()
     * @uses WarehouseProduct::setPrice()
     * @uses WarehouseProduct::setConsumerPrice()
     * @uses WarehouseProduct::setWholesalePrice()
     * @uses WarehouseProduct::setQtyMin()
     * @uses WarehouseProduct::setQtyMax()
     * @uses WarehouseProduct::setIsActive()
     * @uses WarehouseProduct::setWearhouseCode()
     * @uses WarehouseProduct::setGoodCode()
     * @param int $qty
     * @param float $price
     * @param float $consumerPrice
     * @param float $wholesalePrice
     * @param float $qtyMin
     * @param float $qtyMax
     * @param bool $isActive
     * @param string $wearhouseCode
     * @param string $goodCode
     */
    public function __construct($qty = null, $price = null, $consumerPrice = null, $wholesalePrice = null, $qtyMin = null, $qtyMax = null, $isActive = null, $wearhouseCode = null, $goodCode = null)
    {
        $this
            ->setQty($qty)
            ->setPrice($price)
            ->setConsumerPrice($consumerPrice)
            ->setWholesalePrice($wholesalePrice)
            ->setQtyMin($qtyMin)
            ->setQtyMax($qtyMax)
            ->setIsActive($isActive)
            ->setWearhouseCode($wearhouseCode)
            ->setGoodCode($goodCode);
    }
    /**
     * Get Qty value
     * @return int
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param int $qty
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setQty($qty = null)
    {
        // validation for constraint: int
        if (!is_null($qty) && !is_numeric($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get ConsumerPrice value
     * @return float
     */
    public function getConsumerPrice()
    {
        return $this->ConsumerPrice;
    }
    /**
     * Set ConsumerPrice value
     * @param float $consumerPrice
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setConsumerPrice($consumerPrice = null)
    {
        $this->ConsumerPrice = $consumerPrice;
        return $this;
    }
    /**
     * Get WholesalePrice value
     * @return float
     */
    public function getWholesalePrice()
    {
        return $this->WholesalePrice;
    }
    /**
     * Set WholesalePrice value
     * @param float $wholesalePrice
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setWholesalePrice($wholesalePrice = null)
    {
        $this->WholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Get QtyMin value
     * @return float
     */
    public function getQtyMin()
    {
        return $this->QtyMin;
    }
    /**
     * Set QtyMin value
     * @param float $qtyMin
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setQtyMin($qtyMin = null)
    {
        $this->QtyMin = $qtyMin;
        return $this;
    }
    /**
     * Get QtyMax value
     * @return float
     */
    public function getQtyMax()
    {
        return $this->QtyMax;
    }
    /**
     * Set QtyMax value
     * @param float $qtyMax
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setQtyMax($qtyMax = null)
    {
        $this->QtyMax = $qtyMax;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get WearhouseCode value
     * @return string|null
     */
    public function getWearhouseCode()
    {
        return $this->WearhouseCode;
    }
    /**
     * Set WearhouseCode value
     * @param string $wearhouseCode
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setWearhouseCode($wearhouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($wearhouseCode) && !is_string($wearhouseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wearhouseCode)), __LINE__);
        }
        $this->WearhouseCode = $wearhouseCode;
        return $this;
    }
    /**
     * Get GoodCode value
     * @return string|null
     */
    public function getGoodCode()
    {
        return $this->GoodCode;
    }
    /**
     * Set GoodCode value
     * @param string $goodCode
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public function setGoodCode($goodCode = null)
    {
        // validation for constraint: string
        if (!is_null($goodCode) && !is_string($goodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodCode)), __LINE__);
        }
        $this->GoodCode = $goodCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\WarehouseProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
