<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncGoodsWarehouseData Structs
 * @subpackage Structs
 */
class SyncGoodsWarehouseData extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The wearhouseGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct
     */
    public $wearhouseGoods;
    /**
     * Constructor method for SyncGoodsWarehouseData
     * @uses SyncGoodsWarehouseData::setUserName()
     * @uses SyncGoodsWarehouseData::setPassword()
     * @uses SyncGoodsWarehouseData::setWearhouseGoods()
     * @param string $userName
     * @param string $password
     * @param \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct $wearhouseGoods
     */
    public function __construct($userName = null, $password = null, \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct $wearhouseGoods = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setWearhouseGoods($wearhouseGoods);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \ServicePyramid\Structs\SyncGoodsWarehouseData
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \ServicePyramid\Structs\SyncGoodsWarehouseData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get wearhouseGoods value
     * @return \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct|null
     */
    public function getWearhouseGoods()
    {
        return $this->wearhouseGoods;
    }
    /**
     * Set wearhouseGoods value
     * @param \ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct $wearhouseGoods
     * @return \ServicePyramid\Structs\SyncGoodsWarehouseData
     */
    public function setWearhouseGoods(\ServicePyramid\Arrays\ArrayOfSyncWarehouseProduct $wearhouseGoods = null)
    {
        $this->wearhouseGoods = $wearhouseGoods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\SyncGoodsWarehouseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
