<?php

namespace ServicePyramid\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethod Structs
 * @subpackage Structs
 */
class PaymentMethod extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The ActionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActionCode;
    /**
     * The ServiceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceId;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The TerminalId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminalId;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ImagePath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImagePath;
    /**
     * The CallbackUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallbackUrl;
    /**
     * Constructor method for PaymentMethod
     * @uses PaymentMethod::setId()
     * @uses PaymentMethod::setType()
     * @uses PaymentMethod::setActionCode()
     * @uses PaymentMethod::setServiceId()
     * @uses PaymentMethod::setIsActive()
     * @uses PaymentMethod::setUserName()
     * @uses PaymentMethod::setPassword()
     * @uses PaymentMethod::setTerminalId()
     * @uses PaymentMethod::setDescription()
     * @uses PaymentMethod::setImagePath()
     * @uses PaymentMethod::setCallbackUrl()
     * @param int $id
     * @param string $type
     * @param int $actionCode
     * @param string $serviceId
     * @param bool $isActive
     * @param string $userName
     * @param string $password
     * @param string $terminalId
     * @param string $description
     * @param string $imagePath
     * @param string $callbackUrl
     */
    public function __construct($id = null, $type = null, $actionCode = null, $serviceId = null, $isActive = null, $userName = null, $password = null, $terminalId = null, $description = null, $imagePath = null, $callbackUrl = null)
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setActionCode($actionCode)
            ->setServiceId($serviceId)
            ->setIsActive($isActive)
            ->setUserName($userName)
            ->setPassword($password)
            ->setTerminalId($terminalId)
            ->setDescription($description)
            ->setImagePath($imagePath)
            ->setCallbackUrl($callbackUrl);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \ServicePyramid\Enums\PaymentMethodType::valueIsValid()
     * @uses \ServicePyramid\Enums\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\ServicePyramid\Enums\PaymentMethodType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \ServicePyramid\Enums\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return int
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param int $actionCode
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setActionCode($actionCode = null)
    {
        // validation for constraint: int
        if (!is_null($actionCode) && !is_numeric($actionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($actionCode)), __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get ServiceId value
     * @return string
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }
    /**
     * Set ServiceId value
     * @uses \ServicePyramid\Enums\BankServiceId::valueIsValid()
     * @uses \ServicePyramid\Enums\BankServiceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceId
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: enumeration
        if (!\ServicePyramid\Enums\BankServiceId::valueIsValid($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceId, implode(', ', \ServicePyramid\Enums\BankServiceId::getValidValues())), __LINE__);
        }
        $this->ServiceId = $serviceId;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get TerminalId value
     * @return string|null
     */
    public function getTerminalId()
    {
        return $this->TerminalId;
    }
    /**
     * Set TerminalId value
     * @param string $terminalId
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminalId)), __LINE__);
        }
        $this->TerminalId = $terminalId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ImagePath value
     * @return string|null
     */
    public function getImagePath()
    {
        return $this->ImagePath;
    }
    /**
     * Set ImagePath value
     * @param string $imagePath
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setImagePath($imagePath = null)
    {
        // validation for constraint: string
        if (!is_null($imagePath) && !is_string($imagePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imagePath)), __LINE__);
        }
        $this->ImagePath = $imagePath;
        return $this;
    }
    /**
     * Get CallbackUrl value
     * @return string|null
     */
    public function getCallbackUrl()
    {
        return $this->CallbackUrl;
    }
    /**
     * Set CallbackUrl value
     * @param string $callbackUrl
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public function setCallbackUrl($callbackUrl = null)
    {
        // validation for constraint: string
        if (!is_null($callbackUrl) && !is_string($callbackUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callbackUrl)), __LINE__);
        }
        $this->CallbackUrl = $callbackUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ServicePyramid\Structs\PaymentMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
